<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiLogsController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "cms_logs";        
				$this->permalink   = "logs";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        //if($postdata['url']=="https://siapkk.banjarbarukota.go.id/admin/mendaftaruid"){
    		        $postdata['ipaddress'] = $this->get_client_ip();
    		        $postdata['useragent'] = $_SERVER['HTTP_USER_AGENT'];
		        //}
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                if($postdata['mode']=='cari_nama'){
                    $result = $this->step1($postdata['nik']);
                }
                if($postdata['mode']=='cari_induk'){
                    $result = $this->step2($postdata['nik'],$postdata['nama_lgkp']);
                }
                if($postdata['mode']=='verif_selection'){
                    $result = $this->steplast($postdata['nik'],$postdata['nama_lgkp'],$postdata['nama_lgkp_ibu']);
                }
                if($postdata['mode']=='cari_nik'){
                    $result = $this->sync($postdata['nik']);
                }
		    }
		    
		    public function get_client_ip() {
                $ipaddress = '';
                if (getenv('HTTP_CLIENT_IP'))
                    $ipaddress = getenv('HTTP_CLIENT_IP');
                else if(getenv('HTTP_X_FORWARDED_FOR'))
                    $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
                else if(getenv('HTTP_X_FORWARDED'))
                    $ipaddress = getenv('HTTP_X_FORWARDED');
                else if(getenv('HTTP_FORWARDED_FOR'))
                    $ipaddress = getenv('HTTP_FORWARDED_FOR');
                else if(getenv('HTTP_FORWARDED'))
                   $ipaddress = getenv('HTTP_FORWARDED');
                else if(getenv('REMOTE_ADDR'))
                    $ipaddress = getenv('REMOTE_ADDR');
                else
                    $ipaddress = 'UNKNOWN';
                return $ipaddress;
            }
            
            public function step1($nik)
            {
                $data = [];
                $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
                $time = time();
                $agent = $_SERVER['HTTP_USER_AGENT'];
                
                $token = md5($sk . $time . $agent);
                
        		$data1 = [
        			'nik' => $nik,
        			'token' => '1234567890',
        			'mode' => 'cari_nama'
        		];
        
        		$curl = curl_init();
        
        		curl_setopt_array($curl, array(
        			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
        			CURLOPT_RETURNTRANSFER => true,
        			CURLOPT_ENCODING => "",
        			CURLOPT_MAXREDIRS => 10,
        			CURLOPT_TIMEOUT => 30000,
        			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        			CURLOPT_CUSTOMREQUEST => "POST",
        			CURLOPT_POSTFIELDS => json_encode($data1),
        			CURLOPT_HTTPHEADER => array(
        				"accept: application/json",
        				"content-type: application/json",
        				"origin: https://siapkk.banjarbarukota.go.id",
        				"X-Authorization-Token:".$token,
        				"X-Authorization-Time:". $time,
        				"User-Agent:".$agent
        			),
        		));
        
        		$response = curl_exec($curl);
        		$err = curl_error($curl);
        
        		if ($err) {
        			$hasil = $err;
        		} else {
        			$hasil= json_decode($response);	
        		}
        		curl_close($curl);
        		
        		return $hasil;
        	
            }
            
            public function step2($nik,$nama)
            {
                $data = [];
                $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
                $time = time();
                $agent = $_SERVER['HTTP_USER_AGENT'];
                
                $token = md5($sk . $time . $agent);
                
        		$data1 = [
        			'nik' => $nik,
        			'nama_lgkp' => $nama,
        			'token' => '1234567890',
        			'mode' => 'cari_induk'
        		];
        
        		$curl = curl_init();
        
        		curl_setopt_array($curl, array(
        			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
        			CURLOPT_RETURNTRANSFER => true,
        			CURLOPT_ENCODING => "",
        			CURLOPT_MAXREDIRS => 10,
        			CURLOPT_TIMEOUT => 30000,
        			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        			CURLOPT_CUSTOMREQUEST => "POST",
        			CURLOPT_POSTFIELDS => json_encode($data1),
        			CURLOPT_HTTPHEADER => array(
        				"accept: application/json",
        				"content-type: application/json",
        				"origin: https://siapkk.banjarbarukota.go.id",
        				"X-Authorization-Token:".$token,
        				"X-Authorization-Time:". $time,
        				"User-Agent:".$agent
        			),
        		));
        
        		$response = curl_exec($curl);
        		$err = curl_error($curl);
        
        		if ($err) {
        			$hasil = $err;
        		} else {
        			$hasil= json_decode($response);	
        		}
        		curl_close($curl);
        		
        		return $hasil;
        		
        		
            }
            
            public function steplast($nik,$nama,$ibu)
            {
                $data = [];
                $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
                $time = time();
                $agent = $_SERVER['HTTP_USER_AGENT'];
                
                $token = md5($sk . $time . $agent);
                
        		$data1 = [
        			'nik' => $nik,
        			'nama_lgkp' => $nama,
        			'nama_lgkp_ibu' => $ibu,
        			'token' => '1234567890',
        			'mode' => 'verif_selection'
        		];
        
        		$curl = curl_init();
        
        		curl_setopt_array($curl, array(
        			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
        			CURLOPT_RETURNTRANSFER => true,
        			CURLOPT_ENCODING => "",
        			CURLOPT_MAXREDIRS => 10,
        			CURLOPT_TIMEOUT => 30000,
        			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        			CURLOPT_CUSTOMREQUEST => "POST",
        			CURLOPT_POSTFIELDS => json_encode($data1),
        			CURLOPT_HTTPHEADER => array(
        				"accept: application/json",
        				"content-type: application/json",
        				"origin: https://siapkk.banjarbarukota.go.id",
        				"X-Authorization-Token:".$token,
        				"X-Authorization-Time:". $time,
        				"User-Agent:".$agent
        			),
        		));
        
        		$response = curl_exec($curl);
        		$err = curl_error($curl);
        
        		if ($err) {
        			$hasil = $err;
        		} else {
        			$hasil= json_decode($response);	
        		}
        		curl_close($curl);
        		
        		return $hasil;
        		
        		
            }
            
            public function sync($nik)
            {
                $data = [];
                $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
                $time = time();
                $agent = $_SERVER['HTTP_USER_AGENT'];
                
                $token = md5($sk . $time . $agent);
                
        		$data1 = [
        			'nik' => $nik,
        			'token' => '1234567890',
        			'mode' => 'cari_nik'
        		];
        
        		$curl = curl_init();
        
        		curl_setopt_array($curl, array(
        			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
        			CURLOPT_RETURNTRANSFER => true,
        			CURLOPT_ENCODING => "",
        			CURLOPT_MAXREDIRS => 10,
        			CURLOPT_TIMEOUT => 30000,
        			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        			CURLOPT_CUSTOMREQUEST => "POST",
        			CURLOPT_POSTFIELDS => json_encode($data1),
        			CURLOPT_HTTPHEADER => array(
        				"accept: application/json",
        				"content-type: application/json",
        				"origin: https://siapkk.banjarbarukota.go.id",
        				"X-Authorization-Token:".$token,
        				"X-Authorization-Time:". $time,
        				"User-Agent:".$agent
        			),
        		));
        
        		$response = curl_exec($curl);
        		$err = curl_error($curl);
        
        		if ($err) {
        			$hasil = $err;
        		} else {
        			$hasil= json_decode($response);	
        		}
        		curl_close($curl);
        		
        		return $hasil;
        		
        		
            }

		}