<?php namespace App\Http\Controllers;
    header("Access-Control-Allow-Origin: *");

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiNearByController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "lokasi";        
				$this->permalink   = "near_by";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
    				$result['data'] = DB::Table($this->table)
    					->join('districts','districts.id','lokasi.district_id')
    					->join('villages','villages.id','lokasi.village_id')
    					->leftJoin('kategori_lokasi','kategori_lokasi.id','lokasi.default_icon')
    					->select('lokasi.*','districts.name as kecamatan', 'villages.name as kelurahan','kategori_lokasi.icon as default_icon_path',DB::raw('111.111 *
                            DEGREES(ACOS(LEAST(1.0, COS(RADIANS(lokasi.lat))
                                 * COS(RADIANS('.$postdata['user_lat'].'))
                                 * COS(RADIANS(lokasi.lon - '.$postdata['user_lon'].'))
                                 + SIN(RADIANS(lokasi.lat))
                                 * SIN(RADIANS('.$postdata['user_lat'].'))))) AS jarak_km'))
    					->where(DB::raw('111.111 *
                            DEGREES(ACOS(LEAST(1.0, COS(RADIANS(lokasi.lat))
                                 * COS(RADIANS('.$postdata['user_lat'].'))
                                 * COS(RADIANS(lokasi.lon - '.$postdata['user_lon'].'))
                                 + SIN(RADIANS(lokasi.lat))
                                 * SIN(RADIANS('.$postdata['user_lat'].')))))'),'<=',$postdata['jarak'])
    					->get();
					
				foreach($result['data'] as $data){
						
						$bagambar = DB::Table('media')->where('id_ortu',$data->id)->where('parent',$this->table)->get();
						if($bagambar){
							$gambarnya = array();
							foreach($bagambar as $gambar){
								array_push($gambarnya, $gambar);
							}
							$data->gambar = $gambarnya;							
						}
						
				}
		    }

		}