<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiProdukByKategoriController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "produk";        
				$this->permalink   = "produk_by_kategori";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        if($result['api_status']==1){
		            foreach($result['data'] as $data){
    		            $photos = DB::table('photo_produk')->where('produk_id',$data->id)->get();
    		            $satuan = DB::table('satuan_berat')->where('id',$data->satuan_berat_id)->first();
    		            if($photos){
    		                $photonya = array();
    		                foreach($photos as $photo){
    		                    array_push($photonya,CRUDBooster::publicPath($photo->file));
    		                }
    		                $data->photo = $photonya;
    		            }
    		            $data->rating = $this->rand_float(5,45);
    		            $data->isFavorite = rand(0,1) == 1;
    		            $data->isPopular = rand(0,1) == 1;
    		            $data->colors = array('0xFFF6625E', '0xFF836DB8', '0xFFDECB9C');
    		            $data->satuan_berat = $satuan->simbol;
		            }
		            $result['data']->unique()->sortBy('rating',  SORT_REGULAR,  true);
		        }

		    }
		    
		    function rand_float($st_num=0,$end_num=1,$mul=10)
            {
                if ($st_num>$end_num) return false;
                $rand =  mt_rand ($st_num, $end_num);
                return round($rand,2);
            }

		}