<?php namespace App\Http\Controllers;

        header('Access-Control-Allow-Origin: *');

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiProdukController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "produk";        
				$this->permalink   = "produk";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
                //$query->paginate(2);
		    }

		    public function hook_after($postdata,&$result) {
		        if($result['api_status']==1){
		            // dd($result['data'] );
		            foreach($result['data'] as $data){
    		            $photos = DB::table('photo_produk')->where('produk_id',$data->id)->get();
    		            $satuan = DB::table('berat')->where('id',$data->satuan_berat)->first();
    		            $kategori = DB::table('kategori_produk')->where('id',$data->kategori_produk_id)->first();
    		            if($postdata['user_lat']){
    		                $usaha = DB::table('umkm_usaha')->where('id',$data->umkm_usaha_id)
        		                ->select('umkm_usaha.*',DB::raw('111.111 *
                                     DEGREES(ACOS(LEAST(1.0, COS(RADIANS(lat))
                                     * COS(RADIANS('.$postdata['user_lat'].'))
                                     * COS(RADIANS(lon - '.$postdata['user_lon'].'))
                                     + SIN(RADIANS(lat))
                                     * SIN(RADIANS('.$postdata['user_lat'].'))))) AS jarak_km'))
                                ->first();
                            
                            
                                
    		                $lokasi = DB::table('lokasi')->where('id',$usaha->lokasi_id)
    		                ->select('lokasi.*',DB::raw('111.111 *
                                 DEGREES(ACOS(LEAST(1.0, COS(RADIANS(lat))
                                 * COS(RADIANS('.$postdata['user_lat'].'))
                                 * COS(RADIANS(lon - '.$postdata['user_lon'].'))
                                 + SIN(RADIANS(lat))
                                 * SIN(RADIANS('.$postdata['user_lat'].'))))) AS jarak_km'))
                            ->first();
                            
    		            }else{
    		                $usaha = DB::table('umkm_usaha')->where('id',$data->umkm_usaha_id)->first();
    		                $lokasi = DB::table('lokasi')->where('id',$usaha->lokasi_id)->first();
    		            }
    		            
    		           
    		            
    		            if($photos){
    		                $photonya = array();
    		                foreach($photos as $photo){
    		                    $photo->file = CRUDBooster::publicPath($photo->file);
    		                    array_push($photonya,CRUDBooster::publicPath($photo->file));
    		                }
    		                $data->photo = $photos;
    		            }
    		            $rating = DB::table("reaksi")
									->where('nama_table','produk')
									->where('key_id',$data->id)
									->count();
							
						//dd($rating);
						
						$data->rating = $rating;
    		            
    		            $myfav = DB::table('reaksi')
    		                    ->where('nama_table','produk')
    		                    ->where('key_id',$data->id)
    		                    ->where('user_id',$postdata['user_id'])
    		                    ->where('master_reaksi_id','1')
    		                    ->first();
    		            if($myfav){
    		                $data->isFavorite = $myfav->id;
    		            }else{
    		                $data->isFavorite = 0;
    		            }
    		            
    		            $data->isPopular = rand(0,1) == 1;
    		            $data->colors = array('0xFFF6625E', '0xFF836DB8', '0xFFDECB9C');
    		            $data->satuan_berat_id = $satuan->id;
    		            $data->satuan_berat = $satuan->simbol;
    		            if($lokasi){
    		                $data->lokasi = $lokasi->nama;
    		                $data->usaha = $usaha->nama_usaha;
							$data->photo_usaha = $usaha->photo;
							$data->verified = $usaha->verified;
    		                $data->jarak = round($lokasi->jarak_km,1);
    		                $data->lat = $lokasi->lat;
    		                $data->lon = $lokasi->lon;
    		            }else{
    		                $data->lokasi = "0";
    		                $data->usaha = $usaha->nama_usaha;
							$data->photo_usaha = $usaha->photo;
							$data->verified = $usaha->verified;
    		                $data->jarak = round($usaha->jarak_km,1);
    		                $data->lat = $usaha->lat;
    		                $data->lon = $usaha->lon;
        		        }
        		        $owner = DB::table('warga_bjb')->where('id',$usaha->warga_bjb_id)->first();
        		        $data->nik = $owner->nik;
						$cms_user = DB::table('cms_users')->where('nik',$owner->nik)->first();
						$data->nama_user = $cms_user->name;
						if($cms_user->photo==null){
							$data->photo_user = "https://siapkk.banjarbarukota.go.id/vendor/crudbooster/avatar.jpg";
						}else{
							$data->photo_user = $cms_user->photo;
						}
    		            $data->kategori = $kategori->nama_kategori;
		                $data->kategori_icon = CRUDBooster::publicPath($kategori->icon);
    		            
    		            
		            }
		            
		           
		           // dd($postdata['data']);
		            
		            
		            if($postdata['reorderdesc']){
		                $result['data'] = $result['data']->sortByDesc($postdata['reorder'])->values();
		            }
		            if($postdata['reorder']){
		                $result['data'] = $result['data']->sortBy($postdata['reorder'])->values();
		            }
		            if($postdata['isFavourite']==1){
		                $result['data'] = $result['data']->where('isFavorite','>',0)->values();
		            }
		            if($postdata['jarak']){
		                $result['data'] = $result['data']->where('jarak','<=',$postdata['jarak'])->values();
		            }
		        }

		    }
		    
		    function rand_float($st_num=0,$end_num=1,$mul=10)
            {
                if ($st_num>$end_num) return false;
                $rand =  mt_rand ($st_num, $end_num);
                return round($rand,2);
            }
            
        

		}