<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiRegistrasiv2Controller extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "registerv2";        
				$this->permalink   = "registrasiv2";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        $postdata['created_at'] = now();
		        if($postdata['no_telp']){
                    $attemp = DB::table('registerv2')->where('nik',$postdata['nik'])->orWhere('no_telp',$postdata['no_telp'])->get();
                    if(sizeof($attemp)>=3){
                        $resp = response()->json(['api_stastus'=>0,'api_message'=>'Terlalu banyak percobaan, Silahkan hubungi admin']);
                        $resp->send();
                        exit;
                    }else{
                        $exist = DB::table('cms_users')->where('nik',$postdata['nik'])->first();
                        if($exist){
                            $resp = response()->json(['api_stastus'=>0,'api_message'=>'NIK Sudah terdaftar !']);
                            $resp->send();
                            exit;
                        }else{
                            $warga = DB::table('warga_bjb')->where('nik',$postdata['nik'])->first();
                            if(!$warga){
                                DB::table('warga_bjb')->insert([
                                    'nik'=>$postdata['nik'],
                                    'nama_lgkp'=>$postdata['nama_lgkp'],
                                    'jk'=>'L',
                                    'tmpt_lhr'=>'unverified',
                                    'tgl_lhr'=>'1900-01-01',
                                    'nama_prop' => 62,
                                    'nama_kab' => 6271,
                                    'nama_kec' => 627103,
                                    'nama_kel' => 6271031001,
                                    'updated_by' => 1,
                                    'updated_by_priv' => 1
                                    ]);
                            }else{
                                similar_text($warga->nama_lgkp,strtoupper($postdata['nama_lgkp']),$similar);
                                if( $similar < 90 ){
                                    $resp = response()->json(['api_stastus'=>0,'api_message'=>'Aduh, Anda sudah terdata, tapi tidak sesuai ! Mohon hubungi admin']);
                                    $resp->send();
                                    exit;
                                }
                            }
                            
                            unset($postdata['nama_lgkp']);
                            unset($postdata['password']);
                            DB::table('registerv2')->where('nik',$postdata['nik'])->where('no_telp',$postdata['no_telp'])->where('otp_status','>',-1)->update(['otp_status'=>-1]);
                        }
                    }
		        }else{
		            $resp = response()->json(['api_stastus'=>0,'api_message'=>'Invalid !']);
                    $resp->send();
                    exit;
		        }
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        if($result['api_status']==1){
                    
                }
		    }

		}