<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiSiapkkController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "cms_users";        
				$this->permalink   = "siapkk";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		      //  $query->join('satuan_kerja','cms_users.dinas_id','satuan_kerja.id');

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                if($result['api_status']==1){
                    CRUDBooster::insertLog(trans("crudbooster.log_login", ['email' => $postdata['nik'], 'ip' => Request::server('REMOTE_ADDR')]));
                    // $result['ori'] = $result;
                    if($result['photo']==null){
                        $result['photo'] = "https://siapkk.banjarbarukota.go.id/vendor/crudbooster/avatar.jpg";
                    }
                    if($result['display_name']==null){
                        $result['display_name'] = $result['name'];
                    }
                    
                    $result['multi_privs'] = array();
                    
                    $privs = DB::table('multi_privs')
                        ->join('cms_privileges','cms_privileges.id','multi_privs.cms_privileges_id')
                        ->where('cms_users_id',$result['id'])
                        ->select('multi_privs.cms_privileges_id','cms_privileges.name')
                        ->get();
                    
                    foreach($privs as $priv){
                        
                         array_push($result['multi_privs'],$priv);
                    }    
                    
                    $warga_priv = DB::table('cms_privileges')
                        ->where('id',2)
                        ->select('id as cms_privileges_id','name')
                        ->first();
                        
                    $warga = DB::table('warga_bjb')
                            ->join('provinces','warga_bjb.nama_prop','provinces.id')
                            ->join('regencies','warga_bjb.nama_kab','regencies.id')
                            ->join('districts','warga_bjb.nama_kec','districts.id')
                            ->join('villages','warga_bjb.nama_kel','villages.id')
                            ->where('nik',$result['nik'])
                            ->selectRaw('warga_bjb.id,nik,alamat,rt,rw, nama_kel, nama_kec, nama_kab, nama_prop, villages.name as kelurahan, districts.name as kecamatan,regencies.name as kabupaten, provinces.name as provinsi')
                            ->first();
                    $result['kependudukan'] = $warga;
                    
                    $result['village_id'] = $warga->nama_kel;
                    
                    array_push($result['multi_privs'],$warga_priv);
                    
                    $result['api_response_fields']="";
                    if($postdata['app_id']){
                        $app = DB::table('apps')->where('app_id',$postdata['app_id'])->where('app_token',$postdata['app_token'])->first();
                        
                        if($app){
                            if($postdata['mode_akses']=='login'){
                                $attemp = DB::table('apps_akses')->where('app_id',$app->id)->where('mode_akses',$postdata['mode_akses'])->count();
                                if($attemp<500000){
                                    $pemilik = DB::table('umkm_pemilik')->where('warga_bjb_id',$warga->id)->first();
                                    $result['pemilik'] = $pemilik;
                                    
                                    $usaha = DB::table('umkm_usaha')->where('warga_bjb_id',$warga->id)->get();
                                    $result['usaha'] = $usaha;
                                    
                                    DB::table('apps_akses')->insert(['app_id'=>$app->id,'mode_akses'=>$postdata['mode_akses'],'created_at'=>now()]);
                                }else{
                                    $result = [];
                                    $result['api_status'] = 0;
                                    $result['api_message'] = 'Akun ini sudah teregistrasi';
                                }
                            }
                            
                           if($postdata['mode_akses']=='berubah'){
                                DB::table('cms_users')->where('id',$result['id'])->update(['selected_id_cms_priv'=>$postdata['priv_id']]);
                                $result = [];
                                $result['api_status'] = 1;
                                $result['api_message'] = 'Privilege berhasil di ubah';
                            }
                        }else{
                            $result = [];
                            $result['api_status'] = 0;
                            $result['api_message'] = 'not authorized';
                        }
                        
                        
                    }
                }
		    }

		}