<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiTambahLokasiController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "lokasi";        
				$this->permalink   = "tambah_lokasi";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
		        if(CRUDBooster::idToPrivilegeId($postdata['created_by'])==1 || CRUDBooster::idToPrivilegeId($postdata['created_by'])==11){
		            $postdata['verified'] = '1';
		        }else{
		            $postdata['owner'] = $postdata['created_by'];
		        }

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
		         DB::Table('master_notif')->insert([
						'target_tags' => 1,
						'content' => CRUDBooster::whoAmI($postdata['user_id'])->name . ' menyukai ' . $postdata['nama_table'] . ' anda',
						'nama_table' => $postdata['nama_table'],
						'url' => $Jumper
					]);
		    }

		}