<?php namespace App\Http\Controllers;

    use Session;
	use Request;
	use DB;
	use Carbon;

    class BlogController extends Controller {
        public function getIndex() {
            $data = [];
            $data['app_name'] = "Berita";
            $data['title'] = "HOME";
            
            $data['berita'] = DB::table('informasi')
                                ->join('cms_users','informasi.created_by','cms_users.id')
                                ->join('kategori','informasi.kategori_id','kategori.id')
                                ->select(DB::raw('informasi.*,cms_users.name as author, kategori.nama_kategori'))
                                ->get();
                                

                                
        //var_dump(asset('vendor/blog/vendor/bootstrap/css/bootstrap.min.css'));
             return view('blog.index',$data);
        }
        
        public function getIndexByKategori($kategori_id) {
            $data = [];
            $data['app_name'] = "Berita";
            $data['title'] = "HOME";
            
            $data['kategori'] = DB::table('kategori')->where('id', $kategori_id)->first();
            
            $data['berita'] = DB::table('informasi')
                                ->join('cms_users','informasi.created_by','cms_users.id')
                                ->join('kategori','informasi.kategori_id','kategori.id')
                                ->select(DB::raw('informasi.*,cms_users.name as author, kategori.nama_kategori'))
                                ->where('informasi.kategori_id',$kategori_id)
                                ->get();
                                

                                
        //var_dump(asset('vendor/blog/vendor/bootstrap/css/bootstrap.min.css'));
             return view('blog.index',$data);
        }
        
        public function getIndexByPriv($priv) {
            $data = [];
            $data['app_name'] = "Berita";
            $data['title'] = "HOME";
            
            
            
            $data['berita'] = DB::table('informasi')
                                ->join('cms_users','informasi.created_by','cms_users.id')
                                ->join('kategori','informasi.kategori_id','kategori.id')
                                ->select(DB::raw('informasi.*,cms_users.name as author, kategori.nama_kategori'))
                                ->where('informasi.statik',0)
                                ->where('informasi.created_by_priv',$priv)
                                ->get();
            
            //$data['kategori'] = DB::table('kategori')->where('id', $data['berita']->kategori_id)->first();
                                

                                
        //var_dump(asset('vendor/blog/vendor/bootstrap/css/bootstrap.min.css'));
             return view('blog.index',$data);
        }
        
        public function getPost($id) {
            $data = [];
            $data['app_name'] = "Berita";
            $data['title'] = "POST";
            
            $data['berita'] = DB::table('informasi')
                                ->join('cms_users','informasi.created_by','cms_users.id')
                                ->join('kategori','informasi.kategori_id','kategori.id')
                                ->select(DB::raw('informasi.*,cms_users.name as author, kategori.nama_kategori'))
                                ->where('informasi.id',$id)
                                ->first();
                                
            $data['sliders'] = DB::table('media')->where('parent','informasi')
                                ->where('id_ortu',$id)
                                ->get();
                                
            return view('blog.post',$data);
        }
        
        public function getSlug($slug) {
            $data = [];
            $data['app_name'] = "Berita";
            $data['title'] = "POST";
            
            $data['berita'] = DB::table('informasi')
                                ->join('cms_users','informasi.created_by','cms_users.id')
                                ->join('kategori','informasi.kategori_id','kategori.id')
                                ->select(DB::raw('informasi.*,cms_users.name as author, kategori.nama_kategori'))
                                ->where('informasi.slug',$slug)
                                ->first();
            
            $data['title'] = $data['berita']->judul;
                                
            $data['sliders'] = DB::table('media')->where('parent','informasi')
                                ->where('id_ortu',$data['berita']->id)
                                ->get();
                                
            return view('blog.post',$data);
        }
    }