<?php
	
	
	namespace App\Http\Controllers;

	use Illuminate\Http\Request;
	use DB;
    use App\Quotation;

	class InformasiController extends Controller
	{
	    public $page_name= 'SITARI';
	    
		public function getIndex(){
		    $data['page_description'] = 'Aplikasi Pertanian, Peternakan dan Perikanan';
		    $data['page_title'] = 'SITARI';
		    $data['page_name'] = $this->page_name;
		    
		    $data['result'] = DB::Table('informasi')
		                      ->join('kategori','kategori.id','informasi.kategori_id')
		                      ->join('cms_users','cms_users.id','informasi.created_by')
		                      ->select('informasi.*','kategori.deskripsi as nama_kategori', 'cms_users.name as penulis')
		                      ->orderby('informasi.id','desc')
		                      ->take(5)
		                      ->get();
		    
			return view('home',$data);
		}
		
		public function getArtikel($slug)
		{
		    $row = DB::Table('informasi')
		                      ->join('kategori','kategori.id','informasi.kategori_id')
		                      ->join('cms_users','cms_users.id','informasi.created_by')
		                      ->select('informasi.*','kategori.nama_kategori', 'cms_users.name as penulis')
		                      ->where('informasi.slug',$slug)
		                      ->first();
		                      
		    $data['row'] = $row;
		    $data['page_title'] = $row->judul . ' | SITARI';
		    $data['page_description'] = str_limit(strip_tags($row_isi,155));
		    $data['page_name'] = $this->page_name;
		    
		    return view('detail',$data);
		}
	}
