<?php
namespace App\Signature;

//require '../Config/esign.php';

class BasicRest
{

    /**
     * 
     */
    private $config;
    /**
     * 
     */
    private $error;

    /**
     * 
     */
    private $header;

    function __construct()
    {
        $this->config = include('config.php'); 
    }

    public function getError()
    {
        return $this->error;
    }

    public function getHeader()
    {
        return $this->header;
    }
    
    public function kirim($url, $method, $queryData = null){
        
        $curl = curl_init();
        
        curl_setopt($curl, CURLOPT_URL, $this->config['host'] . $url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_USERPWD,"silakhi:MyP@ss2S1lakhI!!!");
        // curl_setopt($curl, CURLOPT_USERPWD,"esign:qwerty");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        
        curl_setopt($curl, CURLOPT_POSTFIELDS, $queryData);
        
        
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        // dd($response);

        if ($err) {
            $this->error = $err;
            return $err;
        } else {
            $this->header = $headers;
            $res = json_decode($response);
            if(json_last_error() == JSON_ERROR_NONE) {
                if(isset($res->error)){
                    $this->error = $res->error;
                    return $err;
                }else return $res;
            }
            else return $response;
        }
    }

    /**
     * 
     */
    public function send($url, $method, $queryData = null, array $files = null)
    {
        $curl = curl_init();
        $headers = [];

        if(!is_null($files)) $content = http_build_query($queryData);
        else $content = '';

        $auth = base64_encode($this->config['client_id'].':'.$this->config['client_secret']);

        if(!is_null($files)) {
            $header = 'Content-Type: multipart/form-data;';
            $body = $this->makeCurlFile($files);
        }
        else {
            $header = '';
            $body = '';
        }
        
        //dd($body);
            
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->config['host'] . $url . '?' . $content,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADERFUNCTION => function($curl, $head) use (&$headers)
            {
              $len = strlen($head);
              $head = explode(':', $head, 2);
              if (count($head) < 2) // ignore invalid headers
                return $len;
          
              $headers[strtolower(trim($head[0]))][] = trim($head[1]);
          
              return $len;
            },
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_POSTFIELDS => $body,
            CURLOPT_HTTPHEADER => array(
                'cache-control: no-cache',
                'Authorization: Basic ' . $auth,
                $header
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        
        
        curl_close($curl);
        // dd($response);

        if ($err) {
            $this->error = $err;
            return $err;
        } else {
            $this->header = $headers;
            $res = json_decode($response);
            if(json_last_error() == JSON_ERROR_NONE) {
                if(isset($res->error)){
                    $this->error = $res->error;
                    return $err;
                }else return $res;
            }
            else return $response;
        }
        
    }

    /**
     * 
     */
    private function makeCurlFile(array $files = array()){
        $body = [];
        
        foreach ($files as $k => $v) {
           
            switch (true) {
                case false === $v = realpath(filter_var($v)):
                case !is_file($v):
                case !is_readable($v):
                    return false; // or return false, throw new InvalidArgumentException
            }
            $mime = mime_content_type($v);
            $info = pathinfo($v);
            $name = $info['basename'];
            $body = array_merge($body, [$k => curl_file_create($v, $mime, $name)]);
        }
        //dd($body);
        return $body;
    }
    
}
