<?php
namespace App\Signature;
use CRUDBooster;

//include 'Client/BasicRest.php';

class Esign
{

    public function checkStatus($nik = '')
    {
        $rest = new BasicRest();
        $response = $rest->send('/api/user/status/' . $nik, 'GET');
        if (!$response) return $rest->getError();
        else return $response;
    }

    public function registrasi($nik = '')
    {
        $rest = new BasicRest();

        $data = array(
            'nik' => $nik,
            'nama' => 'Wahyu Indraman Akman',
            'email' => 'windraman@gamil.com',
            'nomor_telepon' => '085286387232',
            'kota' => 'Martapura',
            'provinsi' => 'Kalimantan Selatan',
            'nip' => '1234567890',
            'jabatan' => 'staff ahli',
            'unit_kerja' => 'Informatika'
        );

        $files = array(
            'image_ttd' => $pdf,
            'ktp' => $pdf,
            'surat_rekomendasi' => $pdf
        );

        $response = $rest->send('/api/user/registrasi', 'POST', $data, $files);
        if (!$response) return $rest->getError();
        else return $response;
    }

    public function sign($nik = '', $pass = '', $pdf = '', $tag = '', $imageTTD = '',$reason = 'TTE', $width = '150', $height = '70', $tampilan='visible', $image='true', $page = 1,$xAxis='100.0',$yAxis='-500.0')
    {
        $rest = new BasicRest();
        $ext = pathinfo($pdf, PATHINFO_EXTENSION);
        $filename = basename($pdf, '.' . $ext);
        $directoryName = realpath(dirname(storage_path('app/' . $pdf)));
        
        // dd($directoryName . '/' . $filename );
        
        $data = array(
            'file' => curl_file_create($directoryName . '/' . $filename,'application/pdf',$filename),
            'imageTTD' => curl_file_create(storage_path('app/' .  $imageTTD),'image/png',basename($imageTTD, '.' . $ext)),
            'nik' => $nik,
            'passphrase' => $pass,
            'tampilan' => $tampilan,
            'image' => $image,
            'jenis_response'=> 'BASE64',
            //'reason' => $reason,
            //'halaman' => 'PERTAMA',
           // 'page' => $page,
            //'xAxis' => $xAxis,
            //'yAxis' => $yAxis,
            'width' => $width,
            'height' => $height,
            'tag_koordinat' => $tag,
            //'linkQR' => 'tes',
            //'text' => ''
        );
        
       
        $files = array(
            'file' => public_path( $pdf),
            'imageTTD' => storage_path('app/' .  $imageTTD)
        );
        
        // dd($data);
        
        
        // $response = $rest->kirim('/api/sign/pdf', 'POST', $data);
        $response = $rest->send('/api/sign/pdf', 'POST', $data,$files);
        
        // dd($rest->getError());

        if (!$response){
            
            $resp = (object) [
                'esign_status' => 0,
                'esign_message' =>  $rest->getError()
            ];
            

            return json_encode($resp);
        } else {
            
            $header = $rest->getHeader();
            //dd($header);
           // if($header!=null){
                $file = $rest->send('/api/sign/download/' . $response->id_dokumen, 'GET');
                
                //$file = $response->base64_signed_file;
                
                // dd($file);
    
                $fp = fopen( storage_path('app/uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/' . $filename . '_signed.pdf'), 'wb');
                fwrite($fp, $file);
                fclose($fp);
                
                $resp = (object) [
                    'esign_status' => 1,
                    'esign_message' =>  'Dokumen berhasil ditanda tangani',
                    'esign_file' => $filename . '_signed.pdf'
                ];
                
    
                return json_encode($resp);
            // }else{
            //     $resp = (object) [
            //         'esign_status' => 0,
            //         'esign_message' =>  $rest->getError()
            //      ];
                 
            //      return json_encode($resp);
            // }
        }
    }
}
