@extends('crudbooster::admin_template_no_side_bar')

@section('content')


<?php
    use Carbon\Carbon;
    setlocale(LC_TIME, 'id');
   //var_dump($bantuan);
?>
    <section class="data-bantuan">
        <div class="box">
            <div class="box-header">
                <strong>Data Bantuan</strong>
            </div>
            @foreach($bantuan as $ban)
                <div class="card" >
                    <a data-lightbox='roadtrip' href='{{ asset($ban->photo) }}'><img style='max-width:150px' title="Image For {{$ban->id}}" src='{{ asset($ban->photo) }}'/></a>
                    <div class="card-body">
                        <h5 class="card-title"><strong>{{ '     ' .$ban->bantuan }}</strong></h5>
                            <table  class="table table-hover table-striped table-bordered w-auto">
                                <tr>
                                    <td>
                                        Pemberi Bantuan
                                    </td>
                                    <td>
                                        {{ $ban->pemberi_bantuan }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Tanggal
                                    </td>
                                    <td>
                                        {{ strftime( "%d %B %Y", strtotime($ban->updated_at)) }}
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Keterangan
                                    </td>
                                    <td>
                                        {!! $ban->keterangan !!}
                                    </td>
                                </tr>
                                <?php 
                                    $bantuan_item = DB::table('bantuan_item')->where('bantuan_id',$ban->id)->get();
                                ?>
                                @if(sizeof($bantuan_item)>0)
                                <tr>
                                    <td>
                                        Item
                                    </td>
                                    <td>
                                        @foreach($bantuan_item as $banit)
                                            {!! $banit->item_name . ',' !!}
                                        @endforeach
                                    </td>
                                </tr>
                                @endif
                        </table>
                   </div>
                   <div class="card-footer">
                            <?php
                               // var_dump(date($plt->akhir_daftar) . ' >= ' . date("Y-m-d"));
                            ?>
                            @if( $ban->aktif==1)
                                <a href="{{ CRUDBooster::mainpath('daftar-bantuan/'.$ban->id) }}" class="btn btn-primary" >Buat Permohonan</a>
                                @if(CRUDBooster::myPrivilegeId()!=2)
                                    <a href="{{ CRUDBooster::mainpath('daftar-bantuan/'.$ban->id) }}" class="btn btn-danger">Laporan</a>
                                @endif
                            @endif
                        </div>
                </div>
                <br>
            @endforeach
            
            
        </div>
    </section>
    
@endsection