@extends('layout')
@section('content')
        
    
  <!-- Page Header -->
  <header class="masthead" style="background-image: url({{asset('blog/img/home-bg.jpg')}})">
    <div class="overlay"></div>
    <div class="container">
      <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto">
          <div class="site-heading">
            <h1>{{$page_title}}</h1>
            <span class="subheading">{{$page_description}}</span>
          </div>
        </div>
      </div>
    </div>
  </header>

  <!-- Main Content -->
  <div class="container">
    <div class="row">
      <div class="col-lg-8 col-md-10 mx-auto">

        @foreach($result as $row)
        <div class="post-preview">
          <a href="{{url('artikel/'.$row->slug)}}" title='{{$row->judul}}'>
            <h2 class="post-title">
              {{$row->judul}}
            </h2>
             <p >
              {{$row->nama_kategori}}
            </p>
            <h3 class="post-subtitle">
              {{ strip_tags(substr($row->isi, 0, 200))}}
            </h3>
          </a>
          <p class="post-meta">Diposting Oleh
            <a href="#">{{$row->penulis}}</a>
            pada {{ date('M, d Y', strtotime($row->created_at))}}</p>
        </div>
        <hr>
        @endforeach
        <!-- Pager -->
        <!--<div class="clearfix">-->
        <!--  <a class="btn btn-primary float-right" href="#">Older Posts &rarr;</a>-->
        <!--</div>-->
          
      </div>
    </div>
  </div>

  <hr>
        
@endsection