<!-- First, extends to the CRUDBooster Layout -->

<!DOCTYPE html>
<html lang="en">
  <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <title>{{ $title }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Map showing users of the Leaflet mapping library" />
    <meta name="keywords" content="leaflet, users, map, javascript, cloudmade" />
    <meta name="author" content="Wahyu Indraman - windraman@gmail.com" />

    <!-- Le styles -->
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/css?family=Norican">
    <link type="text/css" rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/assets/bootstrap/css/bootstrap.css') }}">
	<!-- <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous"> -->
    <link type="text/css" rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/assets/leaflet/leaflet.css') }}" />
    <!--[if lte IE 8]><link type="text/css" rel="stylesheet" href="assets/leaflet/leaflet.ie.css" /><![endif]-->
    <link type="text/css" rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/assets/leaflet/plugins/leaflet.markercluster/MarkerCluster.css') }}" />
    <link type="text/css" rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/assets/leaflet/plugins/leaflet.markercluster/MarkerCluster.Default.css') }}" />
    
    <link type="text/css" rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/assets/leaflet/plugins/leaflet.label/leaflet.label.css') }}" />
	<!--<link rel="stylesheet" href="assets/sidebar/L.Control.Sidebar.css" />-->
	<link rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/vendor/owl/owlcarousel/assets/owl.carousel.min.css') }}" />
	<link rel="stylesheet" href="{{ CRUDBooster::publicPath('badapat/vendor/owl/owlcarousel/assets/owl.theme.default.min.css') }}" />
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style type="text/css">
      html, body {
        margin: 0;
        padding: 0;
        height: 100%;
        width: 100%;
        position: absolute;
        overflow:hidden;
      }
      #map {
        width:100%;
        height:100%;
      }
      #loading {
        position: absolute;
        width: 220px;
        height: 19px;
        top: 50%;
        left: 50%;
        margin: -10px 0 0 -110px;
        z-index: 20001;
      }
      #loading .loading-indicator {
        height: auto;
        margin: 0;
      }
      .navbar .brand {
        font-size: 25px;
        font-family: 'Norican', serif;
        font-weight: bold;
        color: white;
      }
      .navbar .nav > li > a {
        padding: 13px 10px 11px;
      }
      .navbar .btn, .navbar .btn-group {
        margin-top: 8px;
      }
      .leaflet-popup-content-wrapper, .leaflet-popup-tip {
        background: #f7f7f7;
      }
      .leaflet-control-geoloc {
        background-image: url({{ CRUDBooster::publicPath('vendor/leaflet/images/location.png') }});
        -webkit-border-radius: 5px 5px 5px 5px;
        border-radius: 5px 5px 5px 5px;
      }
	  video {
	  object-fit: fill;
	}
	
	#sidebar-slider{
		width:111%;
		margin-left: -20px;
		margin-top: -4px;
	}
	
	.owl-container{
		width:300px;
	}
	
	
	/* custom scroll */
	::-webkit-scrollbar {
	  width: 7px;
	}

	/* Track */
	::-webkit-scrollbar-track {
	  background: #f1f1f1; 
	}
	 
	/* Handle */
	::-webkit-scrollbar-thumb {
	  background: #888; 
	}

	/* Handle on hover */
	::-webkit-scrollbar-thumb:hover {
	  background: #555; 
	}
	
	.rating {
	  unicode-bidi: bidi-override;
	  direction: rtl;
	  margin-left:19px;
	}
	.rating > span {
	  display: inline-block;
	  position: relative;
	  width: 1.5em;
	  font-size:22px;
	}
	.rating > span:hover,
	.rating > span:hover ~ span {
	  color: transparent;
	}

	.rating > span:hover:before,
	.rating > span:hover ~ span:before {
	   content: "\2605";
	   position: absolute;
	   color: gold;
	}
	
	.star-glow{
	   content: "\2605";
	   position: absolute;
	   color: gold;
	}
	
	.active-cyan-2 input[type=text]:focus:not([readonly]) {
		border-bottom: 1px solid #4dd0e1;
		box-shadow: 0 1px 0 0 #4dd0e1;
	}
	
	.active-cyan input[type=text] {
		border-bottom: 1px solid #4dd0e1;
		box-shadow: 0 1px 0 0 #4dd0e1;
	}
	
	.searchbox-menu-container{
		display:none;
	}
	
	.rated{
		font-size:16px;
		margin-left:30px;
		margin-top:3px;
	}
	
	.fa-star{
		margin:7px;
	}
	
	.checked{
		color:orange;
	}
	
	.marker-label {
        position: absolute;
        width:1000px;
        font-size:20px;
    }
    
    .my-div-icon{
        width:200px;
        height:40px;
    }
    
    .my-div-image{
        width:40px;
        height:40px;
    }
    
    .my-div-span{
        padding-top:-100px;
        padding-left:-10px;
        width:100px;
        color:blue;
    }
    
    .itemimg{
        max-width:80px;
        margin: 10px;
    }
    
    
    </style>

    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
      <script type="text/javascript">
      WebFontConfig = {
        google: {
            families: ['Norican::latin']
        }
      };
      (function () {
        var wf = document.createElement('script');
        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') + '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
      })();
      </script>
    <![endif]-->
  </head>

  <body>

   <!-- <nav id="map-navi" class="navbar navbar-expand-lg navbar-light bg-light">
	  <!-- <a class="navbar-brand" href="#">BADAPAT</a>
	  <form class="form-inline my-2 my-lg-0" style="margin-left:5px;margin-top:10px">
		  <input id="cari" class="form-control mr-sm-2" type="search" placeholder="Cari" aria-label="Cari">
		  <!-- <button class="btn btn-outline-success my-2 my-sm-0" type="submit">Search</button>
		</form>
	  
	</nav> -->
 <!--   <div id="sidebar">-->
        
		
	<!--	<div id="sidebar-slider" class="owl-carousel owl-theme owl-container">-->
				
	<!--	</div>-->
	<!--	<br>-->
	<!--	<div>-->
	<!--		<h2 ><strong id="sidebar-title"></strong></h2>-->
	<!--	</div>-->
	<!--	<br>-->
	<!--	<table>-->
	<!--		<tr>-->
	<!--			<td>-->
	<!--				<p><small>0.0</small></p>-->
	<!--			</td>-->
	<!--			<td>-->
	<!--				<div class="rating" style="display:none">-->
	<!--					<span id="4" onclick="bintang(5);">☆</span><span id="4" onclick="bintang(4);">☆</span><span id="3" onclick="bintang(3);">☆</span><span id="2" onclick="bintang(2);">☆</span><span id="1" onclick="bintang(1);">☆</span>-->
	<!--				</div>-->
	<!--				<div class="rated"> -->
	<!--					<span class="fa fa-star checked"></span>-->
	<!--					<span class="fa fa-star checked"></span>-->
	<!--					<span class="fa fa-star checked"></span>-->
	<!--					<span class="fa fa-star"></span>-->
	<!--					<span class="fa fa-star"></span>-->
	<!--				</div>-->
	<!--			</td>-->
	<!--			<td>-->
	<!--				<p>&nbsp &nbsp <small>(0)</small></p>-->
	<!--			</td>-->
	<!--		</tr>-->
	<!--	</table>-->
	<!--	<p id="sidebar-tags"></p>		-->
	<!--	<hr>-->
	<!--		<table>-->
	<!--		<tr>-->
	<!--			<td id="sidebar-direction">-->
	<!--				<img style="width:48px;margin-left:20px" src="assets/images/direction.svg" />-->
	<!--			</td>-->
				
	<!--			<td id="sidebar-komentar">-->
	<!--				<img style="width:48px;margin-left:20px" src="assets/images/komentar.svg"/>-->
	<!--			</td>-->
	<!--			<td id="sidebar-share">-->
	<!--				<img style="width:40px;margin-left:20px" src="assets/images/share.svg"/>-->
	<!--			</td>-->
	<!--		</tr>-->
	<!--	</table>-->
	<!--	<hr>-->
	<!--	<ul>-->
	<!--		<li id="sidebar-alamat"></li>-->
	<!--		<li id="sidebar-telepon"></li>-->
	<!--	</ul>-->
 <!--   </div>-->
	<!--<div id="sidebar-right">-->
 <!--       <ul id="list_hasil" class="list-group" style="margin-top:30px;">-->

	<!--	</ul>-->
 <!--   </div>-->
	
    <div id="map" style="width:80%"></div>
    <div style="width:20%;position: fixed;right:0;top:0">
        <div >
            <br>
            <h5 style="text-align:center;"><strong >{{ $bidang->keterangan }}</strong></h5>
            <br>
            <ul id="menu" style="height:600px;overflow-y:scroll;">
               
            </ul>
        </div>
    </div>
    <div id="loading-mask" class="modal-backdrop" style="display:none;"></div>
    <div id="loading" style="display:none;">
        <div class="loading-indicator">
            <img src="{{ CRUDBooster::publicPath('vendor/leaflet/images/ajax-loader.gif') }}">
        </div>
    </div>

    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.min.js"></script>
    <script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/assets/bootstrap/js/bootstrap.min.js') }}"></script>
    <script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/assets/leaflet/leaflet.js') }}"></script>
    <script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/assets/leaflet/plugins/leaflet.markercluster/leaflet.markercluster.js') }}"></script>
    <script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/assets/leaflet/plugins/leaflet.label/leaflet.label.js') }}"></script>
	<script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/assets/sidebar/L.Control.Sidebar.js') }}"></script>
	<script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/assets/rotate/transformMarker.js') }}"></script>
	
	<script type="text/javascript" src="{{ CRUDBooster::publicPath('badapat/vendor/owl/owlcarousel/owl.carousel.js') }}"></script>
	
	
	<script src="{{ CRUDBooster::publicPath('badapat/vendor/leaflet/search/leaflet.customsearchbox.min.js') }}"></script>
    <link href="{{ CRUDBooster::publicPath('badapat/vendor/leaflet/search/searchbox.min.css') }}" rel="stylesheet" />
	

    <script type="text/javascript">
      var map, newUser, users, mapquest, firstLoad, videofirst, Me, places;
      
      var myLat = null;
      var myLon = null;
      var nb = false;
      var myIconFromSiapkk = "";
	  
	  //var host = "http://10.20.20.127/siapkk/public";
	  var host = "https://siapkk.banjarbarukota.go.id/api";

      firstLoad = true;
	  videofirst = true;

      //users = new L.FeatureGroup();
      users = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: true, zoomToBoundsOnClick: true});
	  places = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: false, zoomToBoundsOnClick: true});
	  Me = new L.LayerGroup();
      newUser = new L.LayerGroup();

      mapquest = new L.TileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        maxZoom: 18,
        //attribution: 'Basemap tiles courtesy of <a href="http://www.mapquest.com/" target="_blank">MapQuest</a> <img src="http://developer.mapquest.com/content/osm/mq_logo.png">. Map data (c) <a href="http://www.openstreetmap.org/" target="_blank">OpenStreetMap</a> contributors, CC-BY-SA.'
      });

      map = new L.Map('map', {
        center: new L.LatLng(-3.4777819106581633, 114.80575561523438),
        zoom: 12,
        layers: [mapquest, users, newUser, Me, places]
      });
	  
// 	  var sidebar = L.control.sidebar('sidebar', {
// 			position: 'left'
// 		});

// 		map.addControl(sidebar);

    //   var rightSidebar = L.control.sidebar('sidebar-right', {
    //         position: 'right'
    //     });
    //     map.addControl(rightSidebar);

      var geolocControl = new L.control({
        position: 'bottomright'
      });
      geolocControl.onAdd = function (map) {
        var div = L.DomUtil.create('div', 'leaflet-control-zoom leaflet-control');
        div.innerHTML = '<a class="leaflet-control-geoloc" href="#" onclick="geoLocate(); return false;" title="My location"></a>';
        return div;
      };
      
      map.addControl(geolocControl);
	  
	  // var searchboxControl=createSearchboxControl();
        // var control = new searchboxControl({
            // sidebarTitleText: 'Header',
            // sidebarMenuItems: {
                // Items: [
                    // { type: "link", name: "Link 1 (github.com)", href: "http://github.com", icon: "icon-local-carwash" },
                    // { type: "link", name: "Link 2 (google.com)", href: "http://google.com", icon: "icon-cloudy" },
                    // { type: "button", name: "Button 1", onclick: "alert('button 1 clicked !')", icon: "icon-potrait" },
                    // { type: "button", name: "Button 2", onclick: "button2_click();", icon: "icon-local-dining" },
                    // { type: "link", name: "Link 3 (stackoverflow.com)", href: 'http://stackoverflow.com', icon: "icon-bike" },

                // ]
            // }
        // });

        // control._searchfunctionCallBack = function (searchkeywords)
        // {
            // if (!searchkeywords) {
                // searchkeywords = "The search call back is clicked !!"
            // }
            // alert(searchkeywords);
        // }

        // map.addControl(control);
      
	  // map.zoomControl.setPosition('topright');
	  
	  //map.addControl(new L.Control.Scale());

      //map.locate({setView: true, maxZoom: 3});

      $(document).ready(function() {
		var parent = "{!! $strategis_bidang_id !!}";
        $.ajaxSetup({cache:false});
        //$('#map').css('height', ($(window).height() - 40));
		getKategori(parent);
        
        // getPlaces(12);
		//window.Android.postMessage("getmylocation");
		
		
      });

      $(window).resize(function () {
        //$('#map').css('height', ($(window).height() - 40));
      }).resize();
	  
	  $('.rated').hover(function(){
		  $('.rated').attr('style','display:none');
		  $('.rating').attr('style','display:block');
	  });
	  
	  $('.rating').hover(function(){
		  
	  },function(){
		  $('.rated').attr('style','display:block');
		  $('.rating').attr('style','display:none');
	  });
	  
	  
	  
	  function bintang(star){
		  alert(star);
	  }
	  
	  
      function myLocation(lat, lng, icon){
		myLat = lat;
		myLon = lng;
		
		//window.Android.postMessage("getmyicon");
		
		var markerLocation = new L.LatLng(lat, lng);
		if(myIconFromSiapkk.length>0){
			// var myCustomColour = '#583470';

			// var markerHtmlStyles = 'background-color: '+myCustomColour+';width: 3rem;height: 3rem;display: block;left: -1.5rem;top: -1.5rem;position: relative;border-radius: 3rem 3rem 0;transform: rotate(-'+Android.getDegree()+'deg);border: 1px solid #FFFFFF';
			  
			 // var myIcon = L.divIcon({
				  // className: "my-custom-pin",
				  // iconAnchor: [0, 24],
				  // labelAnchor: [-6, 0],
				  // popupAnchor: [0, -36],
				  // label : "Wahyu",
				  // html: '<span style="'+markerHtmlStyles+'" />'
				// });
              // console.log(myIconFromSiapkk);
			var myIcon = L.icon({
				iconUrl: myIconFromSiapkk,
				iconSize: [30, 30],
				iconAnchor: [25, 25],
				popupAnchor: [3, -20],
				//shadowUrl: 'shlogocctv.png',
				shadowSize: [80, 50],
				shadowAnchor: [20, 35],
				// setTransform: 'rotate('+Android.getDegree()+'deg)'
			});
			
			//console.log(myIcon);
			var marker = new L.Marker(markerLocation,{id:99999,icon:myIcon});
		}else{
			var marker = new L.Marker(markerLocation,{id:99999});
		}
		
		// marker._icon.style.WebkitTransform = marker._icon.style.WebkitTransform + ' rotate(' + Android.getDegree() + 'deg)';
		// marker._icon.style.MozTransform = 'rotate(' + Android.getDegree() + 'deg)';
		
       Me.clearLayers();
       // users.each(function(m) {
            //conlose.log(m._id);
           // map.removeLayer(99999);
        //});
        Me.addLayer(marker);	
		//alert(nb);
		if(nb==false){
		    getNearBy(lat,lng,10);
		    nb=true;
		}
			
	  }
	  
	  
      function geoLocate() {
         window.Android.postMessage("getmylocation");
// 	     var myLoc = Android.getMyLocation();
// 		 var resml = myLoc.split(",");
// 		 map.setView([ resml[0],resml[1]], 17);
// 		 myLat = resml[0];
// 		 myLon = resml[1];
	  }
	  
	  function setMyLoc(lat,lng,icon) {
		 map.setView([lat,lng], 17);
		 myLat = lat;
		 myLon = lng;
		 myIconFromSiapkk = icon;
		 window.Android.postMessage(myIconFromSiapkk);
		 myLocation(lat,lng,myIconFromSiapkk);
	  }

	  
	  function getDirection(lat,lng){
		//  sidebar.hide();
		  Android.getDirection(lat,lng);
	  }

      function initRegistration() {
        // map.addEventListener('click', onMapClick);
        // $('#map').css('cursor', 'crosshair');
        //return false;
		location.href="admin/lokasi/add"
      }

      function cancelRegistration() {
        newUser.clearLayers();
        $('#map').css('cursor', '');
        map.removeEventListener('click', onMapClick, { passive: false });
      }
	  
	  $('#cari').on('input',function(e){
			if(this.value.length > 3){
				//rightSidebar.show();
				//getLokasi(this.value);
				getPlaces(this.value);
			//	sidebar.hide();
			}else{
			//	rightSidebar.hide();
			}
		});
		
		
		
	    function onMarkerClick(e) {
			//console.log(e.target);
			
			// var oldPlayer = document.getElementById('player');
			// if(oldPlayer){
				// videojs(oldPlayer).dispose();
			// }
			//var video = '<iframe style="width:100%;height:100%;" src="admin/lokasi/detail/'+this.options.id +'" allowfullscreen scrolling="no"></iframe>';
			//$('#sidebar').html(video);
			//this._popup.setContent( video );
			// //var vids = "";
			// //if(vids!=videojs(this.options.title)){
			// videojs('player');
			//}			
		//	rightSidebar.hide();
// 			var sb = $('#sidebar');
// 			$('#sidebar-title').html(this.options.desc);
// 			$('#sidebar-tags').html(this.options.tags);
// 			$('#sidebar-alamat').html(this.options.jalan + " " + this.options.nomor + ", " +  this.options.kelurahan + ", " + this.options.kecamatan + ", Kode Pos. " + this.options.kode_pos);
// 			$('#sidebar-telepon').html(this.options.telepon);
// 			$('#sidebar-direction').html('<img style="width:48px;margin-left:20px" src="assets/images/direction.svg" onclick="Android.getDirection('+this.options.lat+','+this.options.lng+')"/>');
// 			$('#sidebar-komentar').html('<img onclick="'+this.options.komentar+'" style="width:48px;margin-left:20px" src="assets/images/komentar.svg" />');
			
// 			$('#sidebar-slider').empty();
// 			$('.owl-carousel').trigger('destroy.owl.carousel');
// 			var gambars = this.options.gambar;
// 			var recode = '';
// 			$.each(gambars, function(i, item) {
// 				 //console.log(gambars[i].file);
// 				 recode += '<div class="item">';
// 				 recode +='<img src="' + host + '/' + gambars[i].file + '"/>';
// 				 recode += '</div>';
// 			});			
// 			$('#sidebar-slider').html(recode);
// 			//$('#komenIframe').attr('src',this.options.komentar);
// 			//console.log(recode);
			
// 			$('.owl-carousel').owlCarousel({
// 				margin:10,
// 				autoHeight:true,
// 				autoplay:false,
// 				items:1,
// 				nav:false,
// 				dots:false
// 			  });
						  
						  
 		//	sidebar.show();
            
		//	Android.closeSoftKeyboard();
		//	Android.openLokasiDetail(this.options.id);
			
		}
		
		function goTo(url){
			location.href = url;
		}
		
	  function getKategori(parent) {
		$('#menu').empty();
		var layers = [];
        $.getJSON(host + "/get_strategis?parent="+parent, function (datu) {
			var data = datu.data;
			//console.log(datu);
			var recode = '';
			$.each(data, function(i, item) {
				
				recode += '<li style="display: inline;" onclick="getPlaces('+ item.id +');" >';
    				recode += '<table>';
        				recode += '<tr>';
            				recode += '<td><img class="itemimg" src="' + item.photo + '"/></td>';
    				        recode += '<td><p><small>' + item.nama + '</small></p></td>' ;
    				    recode += '</tr>';
    				recode += '</table>';
				recode += '</li>';
			});
			$('#menu').append(recode);
		});
	  }
	  
	  function getLokasi(kata) {
		
		$('#list_hasil').empty();
        $.getJSON(host + "/api/cari_lokasi?kata=" + kata + "&user_lat=" + myLat + "&user_lon=" + myLon + "&jarak=5", function (datu) {
			var data = datu.data;
			//console.log(datu);			
			$('#list_hasil').empty();
			$.each(data, function(i, item) {
				var recode = '';
				recode += '<li class="list-group-item"><a>'+data[i].nama+'</a></li>';	
				$('#list_hasil').append(recode);				
			});
			
		});
		
	  }

      function getPlaces(bidang) {
          //alert(resml[0]);
			//sidebar.hide();
		$.getJSON(host + "/get_strategis_marker?strategis_bidang_id=" + bidang, function (datu) {
		    
		  var data = datu.data;
		  //console.log(data);
		  
		  if(data.length>0){
			  users.clearLayers();
			  for (var i = 0; i < data.length; i++) {
			    
				var id = data[i].id;
				var lat = data[i].lat;
				var lon = data[i].lon;
				var location = new L.LatLng(lat, lon);
				var name = data[i].kategori;
				var input = data[i].icon;
				// if(data[i].icon!=null){
				//     var icon = host + "/" + data[i].icon;
				// }else{
				//     var icon = host + "/" + data[i].default_icon_path;
				// }
				//alert(icon);
				var icon = "{!! CRUDBooster::publicPath('img/redpin.png') !!}"
				var deskripsi = data[i].deskripsi;
				var gambars = data[i].gambar;
				var tags = data[i].tags;
				var jalan = data[i].jalan;
				var nomor = data[i].nomor;
				var kelurahan = data[i].kelurahan;
				var kecamatan = data[i].kecamatan;
				var kode_pos = data[i].kode_pos;
				var telepon = data[i].telepon;
				var alamat = jalan + " " + nomor + ", " +  kelurahan + ", " + kecamatan + ", Kode Pos. " + kode_pos;
				var komentar = "Android.openChat('"+data[i].id+"','lokasi');";
				var title = "<div style='text-align: center; margin-left: auto; margin-right: auto;'><div style='font-size: 18px; color: #0078A8;'>"+ data[i].deskripsi + "</div><video id='"+name+"' width=100% height=90% class='video-js vjs-default-skin vjs-16-9 vjs-big-play-centered' muted controls autoplay preload='auto'><source src='http://103.133.56.188:8105/cctv/hls/"+name+".m3u8' type='application/x-mpegURL'></video></div>";

				var myIcon = L.icon({
					iconUrl: icon,
					iconSize: [40, 40],
					iconAnchor: [40, 40],
					popupAnchor: [3, -20],
					//shadowUrl: 'shlogocctv.png',
					shadowSize: [80, 50],
					shadowAnchor: [20, 35]
				});
				
				var cIcon = new L.DivIcon({
                        className: 'my-div-icon',
                        iconAnchor: [40, 40],
                        html: '<table><tr><td><img class="my-div-image" src="'+icon+'"/></td>'+
                              '<td><span class="my-div-span"></span><td></tr></table>'
                    });
				
				var marker = new L.Marker(location, {
				  id: id,
				  title: name,
				  desc : deskripsi,
				  icon: cIcon,
				  gambar : gambars,
				  tags : tags,
				  jalan : jalan,
				  nomor : nomor,
				  kecamatan : kecamatan,
				  kelurahan : kelurahan,
				  kode_pos : kode_pos,
				  alamat : alamat,
				  telepon : telepon,
				  lat : lat,
				  lng : lon,
				  komentar : komentar
				});	
				
				//marker.bindLabel(deskripsi, {permanent: true, className: "my-label", offset: [0, 0] });
				
				users.addLayer(marker);
				
				marker.on('click', onMarkerClick );
				
				//map.fitBounds(users.getBounds());
			}
			
			
          }else if(data.length==0){
			    users.clearLayers();
			}
        }).complete(function() {
          if (firstLoad == true) {
           
            //firstLoad = false;
          };
        });
		

      }
	  
      function getNearBy(user_lat,user_lon,jarak) {
          //alert(resml[0]);
			//sidebar.hide();
			window.Android.postMessage(host + "/api/near_by_crime?user_lat=" + user_lat + "&user_lon=" + user_lon + "&jarak="+jarak+"&verified=1");
		$.getJSON(host + "/api/near_by_crime?user_lat=" + user_lat + "&user_lon=" + user_lon + "&jarak="+jarak+"&verified=1", function (datu) {
		   // window.Android.postMessage(datu);
		  var data = datu.data;
		  
		  
		  
		  if(data.length>0){
			  users.clearLayers();
			  for (var i = 0; i < data.length; i++) {
			    
				var id = data[i].id;
				var lat = data[i].lat;
				var lon = data[i].lon;
				var location = new L.LatLng(lat, lon);
				var name = data[i].kategori;
				var input = data[i].icon;
				// if(data[i].icon!=null){
				//     var icon = host + "/" + data[i].icon;
				// }else{
				    var icon = host + "/" + data[i].default_icon_path;
				// }
				//alert(icon);
				var deskripsi = data[i].kejadian;
				var gambars = data[i].gambar;
				var tags = data[i].tags;
				var jalan = data[i].jalan;
				var nomor = data[i].nomor;
				var kelurahan = data[i].kelurahan;
				var kecamatan = data[i].kecamatan;
				var kode_pos = data[i].kode_pos;
				var telepon = data[i].telepon;
				var alamat = jalan + " " + nomor + ", " +  kelurahan + ", " + kecamatan + ", Kode Pos. " + kode_pos;
				var komentar = "Android.openChat('"+data[i].id+"','lokasi');";
				var title = "<div style='text-align: center; margin-left: auto; margin-right: auto;'><div style='font-size: 18px; color: #0078A8;'>"+ data[i].deskripsi + "</div><video id='"+name+"' width=100% height=90% class='video-js vjs-default-skin vjs-16-9 vjs-big-play-centered' muted controls autoplay preload='auto'><source src='http://103.133.56.188:8105/cctv/hls/"+name+".m3u8' type='application/x-mpegURL'></video></div>";

				var myIcon = L.icon({
					iconUrl: icon,
					iconSize: [40, 40],
					iconAnchor: [50, 50],
					popupAnchor: [3, -20],
					//shadowUrl: 'shlogocctv.png',
					shadowSize: [80, 50],
					shadowAnchor: [20, 35]
				});
				
				var cIcon = new L.DivIcon({
                        className: 'my-div-icon',
                        iconAnchor: [40, 40],
                        html: '<table><tr><td><img class="my-div-image" src="'+icon+'"/></td>'+
                              '<td><span class="my-div-span">'+deskripsi+'</span><td></tr></table>'
                    });
				
				var marker = new L.Marker(location, {
				  id: id,
				  title: name,
				  desc : deskripsi,
				  icon: cIcon,
				  gambar : gambars,
				  tags : tags,
				  jalan : jalan,
				  nomor : nomor,
				  kecamatan : kecamatan,
				  kelurahan : kelurahan,
				  kode_pos : kode_pos,
				  alamat : alamat,
				  telepon : telepon,
				  lat : lat,
				  lng : lon,
				  komentar : komentar
				});	
				
				
				users.addLayer(marker);
				
				marker.on('click', onMarkerClick );
				
				
				map.fitBounds(users.getBounds());
				
			}
			
			
          }else if(data.length==0){
			    users.clearLayers();
			}
        }).complete(function() {
          if (firstLoad == true) {
           
            //firstLoad = false;
          };
        });
		geoLocate();

      }


      map.on('click', function () {
           // sidebar.hide();
			//rightSidebar.hide();
        });

      function onMapClick(e) {
        var markerLocation = new L.LatLng(e.latlng.lat, e.latlng.lng);
        var marker = new L.Marker(markerLocation);
        newUser.clearLayers();
        newUser.addLayer(marker);
        var form =  '<form id="inputform" enctype="multipart/form-data" class="well">'+
              '<label><strong>Name:</strong> <i>marker title</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="name" name="name" />'+
              '<label><strong>Input:</strong> <i>never shared</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="input" name="input" />'+
			  '<label><strong>Deskripsi:</strong> <i>marker description</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="deskripsi" name="deskripsi" />'+
              '<input style="display: none;" type="text" id="lat" name="lat" value="'+e.latlng.lat.toFixed(6)+'" />'+
              '<input style="display: none;" type="text" id="lng" name="lng" value="'+e.latlng.lng.toFixed(6)+'" /><br><br>'+
              '<div class="row-fluid">'+
                '<div class="span6" style="text-align:center;"><button type="button" class="btn" onclick="cancelRegistration()">Cancel</button></div>'+
                '<div class="span6" style="text-align:center;"><button type="button" class="btn btn-primary" onclick="insertStream()">Submit</button></div>'+
              '</div>'+
              '</form>';
        marker.bindPopup(form).openPopup();
      }
    </script>

  </body>
</html>

