<!-- First, extends to the CRUDBooster Layout -->

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>Leaflet Users Map</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Map showing users of the Leaflet mapping library" />
    <meta name="keywords" content="leaflet, users, map, javascript, cloudmade" />
    <meta name="author" content="Bryan R. McBride, GISP - http://bryanmcbride.com" />

    <!-- Le styles -->
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Norican">
    <!-- <link type="text/css" rel="stylesheet" href="http://localhost/siapkk/public/vendor/leaflet/bootstrap/css/bootstrap.css"> -->
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <link type="text/css" rel="stylesheet" href="http://localhost/siapkk/public/vendor/leaflet/leaflet.css" />
    <!--[if lte IE 8]><link type="text/css" rel="stylesheet" href="assets/leaflet/leaflet.ie.css" /><![endif]-->
    <link type="text/css" rel="stylesheet" href="http://localhost/siapkk/public/vendor/leaflet/plugins/leaflet.markercluster/MarkerCluster.css" />
    <link type="text/css" rel="stylesheet" href="http://localhost/siapkk/public/vendor/leaflet/plugins/leaflet.markercluster/MarkerCluster.Default.css" />
	<link rel="stylesheet" href="http://localhost/siapkk/public/vendor/leaflet/sidebar/L.Control.Sidebar.css" />
	<link rel="stylesheet" href="http://localhost/siapkk/public/vendor/crudbooster/assets/owl/owlcarousel/assets/owl.carousel.min.css" />
	<link rel="stylesheet" href="http://localhost/siapkk/public/vendor/crudbooster/assets/owl/owlcarousel/assets/owl.theme.default.min.css" />
    <style type="text/css">
      html, body {
        margin: 0;
        padding: 0;
        height: 100%;
        width: 100%;
        position: absolute;
        overflow:hidden;
      }
      #map {
        width:100%;
        height:100%;
      }
      #loading {
        position: absolute;
        width: 220px;
        height: 19px;
        top: 50%;
        left: 50%;
        margin: -10px 0 0 -110px;
        z-index: 20001;
      }
      #loading .loading-indicator {
        height: auto;
        margin: 0;
      }
      .navbar .brand {
        font-size: 25px;
        font-family: 'Norican', serif;
        font-weight: bold;
        color: white;
      }
      .navbar .nav > li > a {
        padding: 13px 10px 11px;
      }
      .navbar .btn, .navbar .btn-group {
        margin-top: 8px;
      }
      .leaflet-popup-content-wrapper, .leaflet-popup-tip {
        background: #f7f7f7;
      }
      .leaflet-control-geoloc {
        background-image: url(http://localhost/siapkk/public/vendor/leaflet/images/location.png);
        -webkit-border-radius: 5px 5px 5px 5px;
        border-radius: 5px 5px 5px 5px;
      }
	  video {
	  object-fit: fill;
	}
	
	#sidebar-slider{
		width:111%;
		margin-left: -20px;
		margin-top: -4px;
	}
	
	
	/* custom scroll */
	::-webkit-scrollbar {
	  width: 7px;
	}

	/* Track */
	::-webkit-scrollbar-track {
	  background: #f1f1f1; 
	}
	 
	/* Handle */
	::-webkit-scrollbar-thumb {
	  background: #888; 
	}

	/* Handle on hover */
	::-webkit-scrollbar-thumb:hover {
	  background: #555; 
	}
	
	.rating {
	  unicode-bidi: bidi-override;
	  direction: rtl;
	  margin-top:-10px;
	}
	.rating > span {
	  display: inline-block;
	  position: relative;
	  width: 1.5em;
	  font-size:22px;
	}
	.rating > span:hover,
	.rating > span:hover ~ span {
	  color: transparent;
	}

	.rating > span:hover:before,
	.rating > span:hover ~ span:before {
	   content: "\2605";
	   position: absolute;
	   color: gold;
	}
	
	.active-cyan-2 input[type=text]:focus:not([readonly]) {
		border-bottom: 1px solid #4dd0e1;
		box-shadow: 0 1px 0 0 #4dd0e1;
	}
	
	.active-cyan input[type=text] {
		border-bottom: 1px solid #4dd0e1;
		box-shadow: 0 1px 0 0 #4dd0e1;
	}
	
	.searchbox-menu-container{
		display:none;
	}
    </style>

    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
      <script type="text/javascript">
      WebFontConfig = {
        google: {
            families: ['Norican::latin']
        }
      };
      (function () {
        var wf = document.createElement('script');
        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') + '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
      })();
      </script>
    <![endif]-->
  </head>

  <body>

   <nav id="map-navi" class="navbar navbar-expand-lg navbar-light bg-light">
	  <a class="navbar-brand" href="#">BADAPAT</a>
	  <form class="form-inline my-2 my-lg-0">
		  <input id="cari" class="form-control mr-sm-2" type="search" placeholder="Cari" aria-label="Cari">
		  <!-- <button class="btn btn-outline-success my-2 my-sm-0" type="submit">Search</button> -->
		</form>
	  
	</nav>
    <div id="sidebar">
        
		
		<div id="sidebar-slider" class="owl-carousel owl-theme">
				
		</div>
		
		<h3 id="sidebar-title">leaflet-sidebar</h3>
		<table>
			<tr>
				<td>
					<p><small>4.5</small></p>
				</td>
				<td>
					<div class="rating">
						<span>☆</span><span>☆</span><span>☆</span><span>☆</span><span>☆</span>
					</div>
				</td>
				<td>
					<p>&nbsp &nbsp <small>(123)</small></p>
				</td>
			</tr>
		</table>
		<p id="sidebar-tags"></p>		
		<hr>
			<table>
			<tr>
				<td>
					<img style="width:48px;margin-left:20px" src="http://localhost/siapkk/public/vendor/leaflet/images/direction.svg"/>
				</td>
				<td>
					<img style="width:48px;margin-left:20px" src="http://localhost/siapkk/public/vendor/leaflet/images/nearby.svg"/>
				</td>
			</tr>
		</table>
		<hr>
		<ul>
			<li id="sidebar-alamat"></li>
			<li id="sidebar-telepon"></li>
		</ul>
    </div>
	<div id="sidebar-right">
        <ul id="list_hasil" class="list-group" style="margin-top:30px;">
		  <li class="list-group-item active">Cras justo odio</li>
		  <li class="list-group-item">Dapibus ac facilisis in</li>
		  <li class="list-group-item">Morbi leo risus</li>
		  <li class="list-group-item">Porta ac consectetur ac</li>
		  <li class="list-group-item">Vestibulum at eros</li>
		</ul>
    </div>
    <div id="map"></div>
    <div id="loading-mask" class="modal-backdrop" style="display:none;"></div>
    <div id="loading" style="display:none;">
        <div class="loading-indicator">
            <img src="http://localhost/siapkk/public/vendor/leaflet/images/ajax-loader.gif">
        </div>
    </div>

    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.min.js"></script>
    <script type="text/javascript" src="http://localhost/siapkk/public/vendor/leaflet/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="http://localhost/siapkk/public/vendor/leaflet/leaflet.js"></script>
    <script type="text/javascript" src="http://localhost/siapkk/public/vendor/leaflet/plugins/leaflet.markercluster/leaflet.markercluster.js"></script>
	<script type="text/javascript" src="http://localhost/siapkk/public/vendor/leaflet/sidebar/L.Control.Sidebar.js"></script>
	<script type="text/javascript" src="http://localhost/siapkk/public/vendor/crudbooster/assets/owl/owlcarousel/owl.carousel.js"></script>
	
	 <link href="http://localhost/siapkk/public/vendor/videojs/video-js.min.css" rel="stylesheet">
	<script src="http://localhost/siapkk/public/vendor/videojs/video.min.js"></script>
	<script src="http://localhost/siapkk/public/vendor/videojs/videojs-contrib-hls.min.js"></script>
	<script src="http://localhost/siapkk/public/vendor/videojs/videojs.imageOverlay.js"></script>
	<link href="http://localhost/siapkk/public/vendor/videojs/videojs.imageOverlay.css" rel="stylesheet">
	
	<script src="http://localhost/siapkk/public/vendor/leaflet/search/leaflet.customsearchbox.min.js"></script>
    <link href="http://localhost/siapkk/public/vendor/leaflet/search/searchbox.min.css" rel="stylesheet" />
	

    <script type="text/javascript">
      var map, newUser, users, mapquest, firstLoad, videofirst;

      firstLoad = true;
	  videofirst = true;

      //users = new L.FeatureGroup();
      users = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: false, zoomToBoundsOnClick: true});
      newUser = new L.LayerGroup();

      mapquest = new L.TileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        maxZoom: 18,
        attribution: 'Basemap tiles courtesy of <a href="http://www.mapquest.com/" target="_blank">MapQuest</a> <img src="http://developer.mapquest.com/content/osm/mq_logo.png">. Map data (c) <a href="http://www.openstreetmap.org/" target="_blank">OpenStreetMap</a> contributors, CC-BY-SA.'
      });

      map = new L.Map('map', {
        center: new L.LatLng(-3.440513, 114.83058),
        zoom: 14,
        layers: [mapquest, users, newUser]
      });
	  
	  var sidebar = L.control.sidebar('sidebar', {
			position: 'left'
		});

		map.addControl(sidebar);

       var rightSidebar = L.control.sidebar('sidebar-right', {
            position: 'right'
        });
        map.addControl(rightSidebar);
      // GeoLocation Control
      function geoLocate() {
        map.locate({setView: true, maxZoom: 17});
      }
      var geolocControl = new L.control({
        position: 'bottomright'
      });
      geolocControl.onAdd = function (map) {
        var div = L.DomUtil.create('div', 'leaflet-control-zoom leaflet-control');
        div.innerHTML = '<a class="leaflet-control-geoloc" href="#" onclick="geoLocate(); return false;" title="My location"></a>';
        return div;
      };
      
      map.addControl(geolocControl);
	  
	  // var searchboxControl=createSearchboxControl();
        // var control = new searchboxControl({
            // sidebarTitleText: 'Header',
            // sidebarMenuItems: {
                // Items: [
                    // { type: "link", name: "Link 1 (github.com)", href: "http://github.com", icon: "icon-local-carwash" },
                    // { type: "link", name: "Link 2 (google.com)", href: "http://google.com", icon: "icon-cloudy" },
                    // { type: "button", name: "Button 1", onclick: "alert('button 1 clicked !')", icon: "icon-potrait" },
                    // { type: "button", name: "Button 2", onclick: "button2_click();", icon: "icon-local-dining" },
                    // { type: "link", name: "Link 3 (stackoverflow.com)", href: 'http://stackoverflow.com', icon: "icon-bike" },

                // ]
            // }
        // });

        // control._searchfunctionCallBack = function (searchkeywords)
        // {
            // if (!searchkeywords) {
                // searchkeywords = "The search call back is clicked !!"
            // }
            // alert(searchkeywords);
        // }

        // map.addControl(control);
      
	  // map.zoomControl.setPosition('topright');
	  
	  map.addControl(new L.Control.Scale());

      //map.locate({setView: true, maxZoom: 3});

      $(document).ready(function() {
		   
        $.ajaxSetup({cache:false});
        //$('#map').css('height', ($(window).height() - 40));
		//getKategori();

        //getUsers(12);
		
      });

      $(window).resize(function () {
        $('#map').css('height', ($(window).height() - 40));
      }).resize();

      function geoLocate() {
        map.locate({setView: true, maxZoom: 17});
      }

      function initRegistration() {
        // map.addEventListener('click', onMapClick);
        // $('#map').css('cursor', 'crosshair');
        //return false;
		location.href="http://localhost/siapkk/public/admin/lokasi/add"
      }

      function cancelRegistration() {
        newUser.clearLayers();
        $('#map').css('cursor', '');
        map.removeEventListener('click', onMapClick);
      }
	  
	  $('#cari').on('input',function(e){
			if(this.value.length > 3){
				//rightSidebar.show();
				//getLokasi(this.value);
				getUsers(this.value);
				sidebar.hide();
			}else{
				rightSidebar.hide();
			}
		});
		
	    function onMarkerClick(e) {
			//console.log(e.target);
			
			// var oldPlayer = document.getElementById('player');
			// if(oldPlayer){
				// videojs(oldPlayer).dispose();
			// }
			//var video = '<iframe style="width:100%;height:100%;" src="http://localhost/siapkk/public/admin/lokasi/detail/'+this.options.id +'" allowfullscreen scrolling="no"></iframe>';
			//$('#sidebar').html(video);
			//this._popup.setContent( video );
			// //var vids = "";
			// //if(vids!=videojs(this.options.title)){
			// videojs('player');
			//}			
			rightSidebar.hide();
			var sb = $('#sidebar');
			$('#sidebar-title').html(this.options.desc);
			$('#sidebar-tags').html(this.options.tags);
			$('#sidebar-alamat').html(this.options.jalan + " " + this.options.nomor + ", " +  this.options.kelurahan + ", " + this.options.kecamatan + ", Kode Pos. " + this.options.kode_pos);
			$('#sidebar-telepon').html(this.options.telepon);
			
			$('#sidebar-slider').empty();
			$('.owl-carousel').trigger('destroy.owl.carousel');
			var gambars = this.options.gambar;
			var recode = '';
			$.each(gambars, function(i, item) {
				 recode += '<div class="item">';
				 recode +='<img src="' + gambars[i].file + '"/>';
				 recode += '</div>';
			});			
			$('#sidebar-slider').html(recode);
			//console.log(recode);
			
			$('.owl-carousel').owlCarousel({
				margin:10,
				autoHeight:true,
				autoplay:false,
				items:1,
				nav:false,
				dots:false
			  });
						  
						  
			sidebar.show();
		}
		
	  function getKategori() {
		$('#menu_kategori').empty();
		var layers = [];
        $.getJSON("http://localhost/siapkk/public/api/list_kategori", function (datu) {
			var data = datu.data;
			//console.log(datu);
			var recode = '';
			$.each(data, function(i, item) {
				layers.push(data[i].slug);
				
				if(data[i].anak.length>0){
					recode += '<li class="dropdown-submenu list-group-item">';
						recode += '<a class="test" tabindex="-1" href="#" onclick="getUsers('+data[i].id+')">'+data[i].nama+'<span class="caret"></span></a>';
						recode += '<ul class="dropdown-menu">';
					$.each(data[i].anak, function(a, anak) {
						layers.push(data[i].anak[a].slug);
						recode += '<li class="list-group-item"><a tabindex="-1" href="#" onclick="getUsers('+data[i].anak[a].id+')">'+ data[i].anak[a].nama +'</a></li>';
					});
					recode += '</ul>';
					recode += '</li>';
				}else{
					recode += '<li ><a tabindex="-1" href="#" onclick="getUsers('+data[i].id+')">'+ data[i].nama +'</a></li>';
				}
			});
			$('#menu_kategori').append(recode);
		});
		return layers;
	  }
	  
	  function getLokasi(kata) {
		
		$('#list_hasil').empty();
        $.getJSON("http://localhost/siapkk/public/api/cari_lokasi?kata=" + kata , function (datu) {
			var data = datu.data;
			//console.log(datu);			
			$('#list_hasil').empty();
			$.each(data, function(i, item) {
				var recode = '';
				recode += '<li class="list-group-item"><a>'+data[i].nama+'</a></li>';	
				$('#list_hasil').append(recode);				
			});
			
		});
		
	  }

      function getUsers(kata) {
		users.clearLayers();
        //$.getJSON("http://localhost/siapkk/public/api/lokasi?kategori_lokasi_id="+ id_kat, function (datu) {
		$.getJSON("http://localhost/siapkk/public/api/cari_lokasi?kata=" + kata , function (datu) {
		  var data = datu.data;
		  //console.log(datu);
		  users.clearLayers();
          for (var i = 0; i < data.length; i++) {
			var id = data[i].id;
			var lat = data[i].lat;
			var lon = data[i].lon;
            var location = new L.LatLng(lat, lon);
            var name = data[i].kategori;
            var input = data[i].icon;
			var icon = "http://localhost/siapkk/public/" + data[i].icon;
			var deskripsi = data[i].nama;
			var gambars = data[i].gambar;
			var tags = data[i].tags;
			var jalan = data[i].jalan;
			var nomor = data[i].nomor;
			var kelurahan = data[i].kelurahan;
			var kecamatan = data[i].kecamatan;
			var kode_pos = data[i].kode_pos;
			var telepon = data[i].telepon;
			var alamat = jalan + " " + nomor + ", " +  kelurahan + ", " + kecamatan + ", Kode Pos. " + kode_pos;
            var title = "<div style='text-align: center; margin-left: auto; margin-right: auto;'><div style='font-size: 18px; color: #0078A8;'>"+ data[i].deskripsi + "</div><video id='"+name+"' width=100% height=90% class='video-js vjs-default-skin vjs-16-9 vjs-big-play-centered' muted controls autoplay preload='auto'><source src='http://103.133.56.188:8105/cctv/hls/"+name+".m3u8' type='application/x-mpegURL'></video></div>";
			  //console.log(title);
			  //var video = '';
 
            // if (data[i].city.length > 0) {
              // var city = "<div style='font-size: 14px;'>"+ data[i].city +"</div>";
            // }
            // else {
              // var city = "";
            // }
			var myIcon = L.icon({
				iconUrl: icon,
				iconSize: [80, 80],
				iconAnchor: [27, 80],
				popupAnchor: [3, -20],
				//shadowUrl: 'shlogocctv.png',
				shadowSize: [80, 50],
				shadowAnchor: [20, 35]
			});
			
            var marker = new L.Marker(location, {
              id: id,
			  title: name,
			  desc : deskripsi,
			  icon: myIcon,
			  gambar : gambars,
			  tags : tags,
			  jalan : jalan,
			  nomor : nomor,
			  kecamatan : kecamatan,
			  kelurahan : kelurahan,
			  kode_pos : kode_pos,
			  alamat : alamat,
			  telepon : telepon,
            });	
			
			
            //marker.bindPopup("<div id='pop' style='text-align: center; margin-left: auto; margin-right: auto;width:800;height:600px'>"+ title +"</div>", {maxWidth: '600'});
            //var popup = marker.getPopup(); 
			users.addLayer(marker);
			
			marker.on('click', onMarkerClick );
			
			
          }
        }).complete(function() {
          //if (firstLoad == true) {
            map.fitBounds(users.getBounds());
            //firstLoad = false;
          //};
        });
		

      }
	  
	


      function insertUser() {
        $("#loading-mask").show();
        $("#loading").show();
        var name = $("#name").val();
        var email = $("#email").val();
        var website = $("#website").val();
        var city = $("#city").val();
        var lat = $("#lat").val();
        var lng = $("#lng").val();
        if (name.length == 0) {
          alert("Name is required!");
          return false;
        }
        if (email.length == 0) {
          alert("Email is required!");
          return false;
        }
        var dataString = 'name='+ name + '&email=' + email + '&website=' + website + '&city=' + city + '&lat=' + lat + '&lng=' + lng;
        $.ajax({
          type: "POST",
          url: "insert_user.php",
          data: dataString,
          success: function() {
            cancelRegistration();
            users.clearLayers();
            getUsers(12);
            $("#loading-mask").hide();
            $("#loading").hide();
            $('#insertSuccessModal').modal('show');
          }
        });
        return false;
      }
	  
	  function insertStream() {
        $("#loading-mask").show();
        $("#loading").show();
        var name = $("#name").val();
        var input = $("#input").val();
        var deskripsi = $("#deskripsi").val();
        var lat = $("#lat").val();
        var lng = $("#lng").val();
        if (name.length == 0) {
          alert("Name is required!");
          return false;
        }
        if (input.length == 0) {
          alert("Input is required!");
          return false;
        }
		if (deskripsi.length == 0) {
          alert("Deskripsi is required!");
          return false;
        }
        var dataString = 'name='+ name + '&input=' + input + '&deskripsi=' + deskripsi + '&lat=' + lat + '&lng=' + lng;
		//alert(dataString);
        $.ajax({
          type: "POST",
          url: "insert_stream.php",
          data: dataString,
          success: function() {
            cancelRegistration();
            users.clearLayers();
            getUsers(12);
            $("#loading-mask").hide();
            $("#loading").hide();
            $('#insertSuccessModal').modal('show');
          }
        });
        return false;
      }

      function removeUser() {
        var name = $("#email_remove").val();
        var token = $("#token_remove").val();
        if (name.length == 0) {
          alert("Name is required!");
          return false;
        }
        if (token.length == 0) {
          alert("Token is required!");
          return false;
        }
        var dataString = 'name='+ name + '&token=' + token;
        $.ajax({
          type: "POST",
          url: "remove_stream.php",
          data: dataString,
          success: function(data) {
            //console.log(data);
            if (data > 0) {
              $('#removemeModal').modal('hide');
              users.clearLayers();
              getUsers(12);
              $('#removeSuccessModal').modal('show');
            }
            else {
              alert("Incorrect email or token. Please try again.");
            }
          }
        });
        return false;
      }

      map.on('click', function () {
            sidebar.hide();
			rightSidebar.hide();
        });

      function onMapClick(e) {
        var markerLocation = new L.LatLng(e.latlng.lat, e.latlng.lng);
        var marker = new L.Marker(markerLocation);
        newUser.clearLayers();
        newUser.addLayer(marker);
        var form =  '<form id="inputform" enctype="multipart/form-data" class="well">'+
              '<label><strong>Name:</strong> <i>marker title</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="name" name="name" />'+
              '<label><strong>Input:</strong> <i>never shared</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="input" name="input" />'+
			  '<label><strong>Deskripsi:</strong> <i>marker description</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="deskripsi" name="deskripsi" />'+
              '<input style="display: none;" type="text" id="lat" name="lat" value="'+e.latlng.lat.toFixed(6)+'" />'+
              '<input style="display: none;" type="text" id="lng" name="lng" value="'+e.latlng.lng.toFixed(6)+'" /><br><br>'+
              '<div class="row-fluid">'+
                '<div class="span6" style="text-align:center;"><button type="button" class="btn" onclick="cancelRegistration()">Cancel</button></div>'+
                '<div class="span6" style="text-align:center;"><button type="button" class="btn btn-primary" onclick="insertStream()">Submit</button></div>'+
              '</div>'+
              '</form>';
        marker.bindPopup(form).openPopup();
      }
    </script>

  </body>
</html>

