<!-- First, extends to the CRUDBooster Layout -->
@extends('crudbooster::admin_template')
@section('content')
  <!-- Your html goes here -->
  <div class='panel panel-default'>
    <div class='panel-heading'>Form Notulen</div>
    <div class='panel-body'>

      <form method='post' action='{{CRUDBooster::mainpath('save-notulen/'.$row->id)}}' class="form-horizontal">
        @csrf
        <div class='form-group'>
            <input type="hidden" name="new" value="{{ $new }}">
            <div class="col-sm-4">
                <label>Pembicara</label>

                <select style="width:100%" class="form-control select2-hidden-accessible" id="pembicara_id" required="" name="pembicara_id" tabindex="-1" aria-hidden="true">
                    
                    <option value="">** Pilih Peserta</option>
                    @foreach($peserta as $pst)
                        <option selected="" value="{{ $pst->dprd_id }}">{{ $pst->name }}</option>
                    @endforeach
                    </select>
                <br>           
                <button id="paste-isi"><i class="fa fa-paste"></i> Salin dari clipboard </button>

            </div>
            <div class="col-sm-8">
                <label>Isi</label>
                <textarea type='text' id="textarea-isi" name='isi' required class='form-control '>{{$row->isi}}</textarea>
            </div>
   
            
        </div>
         
        <!-- etc .... -->
        <div class='panel-footer'>
          <input type='submit' class='btn btn-primary' id='save-notulen' value='Save changes'/>
        </div>
      </form>
    </div>
    
  </div>
@endsection

@push('head')
    <link rel="stylesheet" type="text/css" href="https://siapkk.banjarbarukota.go.id/vendor/crudbooster/assets/summernote/summernote.css">
@endpush

@push('bottom')
    <script type="text/javascript" src="https://siapkk.banjarbarukota.go.id/vendor/crudbooster/assets/summernote/summernote.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#textarea-isi').summernote({
                height: ($(window).height() - 300),
                callbacks: {
                    onImageUpload: function (image) {
                        uploadImage{{$name}}(image[0]);
                    }
                }
            });

            function uploadImage{{$name}}(image) {
                var data = new FormData();
                data.append("userfile", image);
                $.ajax({
                    url: '{{CRUDBooster::mainpath("upload-summernote")}}',
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: data,
                    type: "post",
                    success: function (url) {
                        var image = $('<img>').attr('src', url);
                        $('#textarea_{{$name}}').summernote("insertNode", image[0]);
                    },
                    error: function (data) {
                        console.log(data);
                    }
                });
            }
            
            if (navigator.clipboard) {
              console.log('Clipboard API available');
            }
            
            if (navigator.clipboard.writeText) {
              console.log('Can copy text to clipboard');
            }
            
            $('#paste-isi').click(async(event) => {
                event.preventDefault();
                var text = null;

              try {
                text = await navigator.clipboard.readText();
              }
              catch (err) {
                console.error('Could not read from clipboard', err);
              }
            
              if (text) {
                var dt = new Date();
                  var time = dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();
                  text = '\r<h3>' +  $('#pembicara_id').find(":selected").text() +  '( ' + time +  ' )</h3>\r<p>' + text + '</p>';
                //set the text
                $('#textarea-isi').html($('#textarea-isi').html() + text);
                $('.note-editable').html($('.note-editable').html() + text);
              }
              event.stopPropagation();
            });
            
            $('#save-notulen').click(function(event) {
               event.stopPropagation(); 
               return true;
            });
        })
    </script>
@endpush