@extends('crudbooster::admin_template_no_side_bar')

@section('content')


<?php
    use Carbon\Carbon;
    setlocale(LC_TIME, 'id');
   // var_dump($pelatihan_baru);
?>
    <section class="data-pelatihan">
        <div class="box">
            <div class="box-header">
                <strong>Data Pelatihan</strong>
            </div>
            <ul class="nav nav-tabs">
              <li class="active"><a href="#baru"  data-toggle="tab">Pelatihan Baru</a></li>
              <li><a href="#akan" data-toggle="tab">Pelatihan Akan Datang</a></li>
              <li><a href="#lampau" data-toggle="tab">Pelatihan Lampau</a></li>
              <li><a href="#semua" data-toggle="tab">Semua Pelatihan</a></li>
            </ul>
            
            <div class="tab-content" id="tabs">
                <div class="tab-pane fade in active" id="baru">
                    @foreach($pelatihan_baru as $plt)
                    <div class="card" >
                        <img class="card-img-top" src="{{ asset($plt->gambar) }}" alt="Card image cap">
                        <div class="card-body">
                            <h5 class="card-title"><strong>{{ '     ' .$plt->nama_pelatihan }}</strong></h5>
                                <table  class="table table-hover table-striped table-bordered w-auto">
                                    <tr>
                                        <td>
                                            Penyelenggara
                                        </td>
                                        <td>
                                            {{ $plt->penyelenggara }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Pendaftaran
                                        </td>
                                        <td>
                                            {{ strftime( "%d %B %Y", strtotime($plt->awal_daftar)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->akhir_daftar))   }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Pelaksanaan
                                        </td>
                                        <td>
                                            {{ strftime( "%d %B %Y", strtotime($plt->tanggal_mulai)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->tanggal_akhir))  }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Tempat
                                        </td>
                                        <td>
                                            {{ $plt->tempat }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Keterangan
                                        </td>
                                        <td>
                                            {!! $plt->keterangan !!}
                                        </td>
                                    </tr>
                                     <tr>
                                        <td>
                                            Kuota
                                        </td>
                                        <td>
                                            {{ $plt->kuota . ' orang'  }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Kuota Terpenuhi
                                        </td>
                                        <td>
                                            {{  $plt->booked . ' orang'  }}
                                        </td>
                                    </tr>
                            </table>
                       </div>
                       <div class="card-footer">
                            <?php
                               // var_dump(date($plt->akhir_daftar) . ' >= ' . date("Y-m-d"));
                            ?>
                            @if( date($plt->akhir_daftar) >= date("Y-m-d"))
                                <a href="{{ CRUDBooster::mainpath('daftar-pelatihan/'.$plt->id) }}" class="btn btn-primary" >Mendaftar</a>
                                @if(CRUDBooster::myPrivilegeId()!=2)
                                    <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                @endif
                            @else
                                @if(CRUDBooster::myPrivilegeId()!=2)
                                    <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                @endif 
                            @endif
                        </div>
                    </div>
                    <br>
                    @endforeach
                </div>
                <div class="tab-pane fade" id="akan">
                    @foreach($pelatihan_akan_datang as $plt)
                     <div class="card" >
                        <img class="card-img-top" src="{{ asset($plt->gambar) }}" alt="Card image cap">
                        <div class="card-body">
                            <h5 class="card-title"><strong>{{ '     ' .$plt->nama_pelatihan }}</strong></h5>
                                <table  class="table table-hover table-striped table-bordered w-auto">
                                    <tr>
                                        <td>
                                            Penyelenggara
                                        </td>
                                        <td>
                                            {{ $plt->penyelenggara }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Pendaftaran
                                        </td>
                                        <td>
                                            {{ strftime( "%d %B %Y", strtotime($plt->awal_daftar)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->akhir_daftar))   }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Pelaksanaan
                                        </td>
                                        <td>
                                            {{ strftime( "%d %B %Y", strtotime($plt->tanggal_mulai)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->tanggal_akhir))  }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Tempat
                                        </td>
                                        <td>
                                            {{ $plt->tempat }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Keterangan
                                        </td>
                                        <td>
                                            {!! $plt->keterangan !!}
                                        </td>
                                    </tr>
                                     <tr>
                                        <td>
                                            Kuota
                                        </td>
                                        <td>
                                            {{ $plt->kuota . ' orang'  }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Kuota Terpenuhi
                                        </td>
                                        <td>
                                            {{  $plt->booked . ' orang'  }}
                                        </td>
                                    </tr>
                            </table>
                       </div>
                       <div class="card-footer">
                            <?php
                               // var_dump(date($plt->akhir_daftar) . ' >= ' . date("Y-m-d"));
                            ?>
                            @if( date($plt->akhir_daftar) >= date("Y-m-d"))
                                <a href="{{ CRUDBooster::mainpath('daftar-pelatihan/'.$plt->id) }}" class="btn btn-primary" >Mendaftar</a> 
                                @if(CRUDBooster::myPrivilegeId()!=2)
                                    <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                @endif
                            @else
                                @if(CRUDBooster::myPrivilegeId()!=2)
                                    <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                @endif 
                            @endif
                        </div>
                    </div>
                    <br>
                    @endforeach
                </div>
                <div class="tab-pane fade" id="lampau">
                   @foreach($pelatihan_lampau as $plt)
                    <div class="box">
                        <img src="{{ asset($plt->gambar) }}" style="width:250px"/>
                        <table  class="table table-hover table-striped table-bordered">
                            <tr>
                                
                                <td>
                                     <table  class="table table-hover table-striped table-bordered">
                                        <tr>
                                            <td colspan="2">
                                                <strong>{{ $plt->nama_pelatihan }}</strong>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Penyelenggara
                                            </td>
                                            <td>
                                                {{ $plt->penyelenggara }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Pendaftaran
                                            </td>
                                            <td>
                                                {{ strftime( "%d %B %Y", strtotime($plt->awal_daftar)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->akhir_daftar))   }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Pelaksanaan
                                            </td>
                                            <td>
                                                {{ strftime( "%d %B %Y", strtotime($plt->tanggal_mulai)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->tanggal_akhir))  }}
                                            </td>
                                        </tr>
                                    <tr>
                                            <td>
                                                Kuota
                                            </td>
                                            <td>
                                                {{ $plt->kuota . ' orang'  }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Kuota Terpenuhi
                                            </td>
                                            <td>
                                                {{  $plt->booked . ' orang'  }}
                                            </td>
                                        </tr>
                                        
                                    </table>
                                </td>
    
                            </tr>
                             <tr>
                                <td colspan="2">
                                    @if( date($plt->akhir_daftar) >= date("Y-m-d"))
                                        <a href="{{ CRUDBooster::mainpath('daftar-pelatihan/'.$plt->id) }}" class="btn btn-primary" >Mendaftar</a> 
                                        @if(CRUDBooster::myPrivilegeId()!=2)
                                            <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                        @endif
                                    @else
                                        @if(CRUDBooster::myPrivilegeId()!=2)
                                            <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                        @endif 
                                    @endif
                                </td>
                            </tr>
                        </table>
                       
                    </div>
                    @endforeach
                </div>
                <div class="tab-pane fade" id="semua">
                    @foreach($pelatihan as $plt)
                    <div class="box">
                        <img src="{{ asset($plt->gambar) }}" style="max-width:250px"/>
                        <table  class="table table-hover table-striped table-bordered">
                            <tr>
                                
                                <td>
                                     <table  class="table table-hover table-striped table-bordered">
                                        <tr>
                                            <td colspan="2">
                                                <strong>{{ $plt->nama_pelatihan }}</strong>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Penyelenggara
                                            </td>
                                            <td>
                                                {{ $plt->penyelenggara }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Pendaftaran
                                            </td>
                                            <td>
                                                {{ strftime( "%d %B %Y", strtotime($plt->awal_daftar)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->akhir_daftar))   }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Pelaksanaan
                                            </td>
                                            <td>
                                                {{ strftime( "%d %B %Y", strtotime($plt->tanggal_mulai)) . ' - ' . strftime( "%d %B %Y", strtotime($plt->tanggal_akhir))  }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Kuota
                                            </td>
                                            <td>
                                                {{ $plt->kuota . ' orang'  }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Kuota Terpenuhi
                                            </td>
                                            <td>
                                                {{  $plt->booked . ' orang'  }}
                                            </td>
                                        </tr>
                                        
                                    </table>
                                </td>
                            </tr>
                             <tr>
                                <td colspan="2">
                                    @if( date($plt->akhir_daftar) >= date("Y-m-d"))
                                        <a href="{{ CRUDBooster::mainpath('daftar-pelatihan/'.$plt->id) }}" class="btn btn-primary" >Mendaftar</a> 
                                        @if(CRUDBooster::myPrivilegeId()!=2)
                                            <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                        @endif
                                    @else
                                        @if(CRUDBooster::myPrivilegeId()!=2)
                                            <a href="{{ CRUDBooster::mainpath('daftar-peserta/'.$plt->id) }}" class="btn btn-danger">Peserta</a>
                                        @endif 
                                    @endif
                                </td>
                            </tr>
                        </table>
                       
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    

@endsection