<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>{{ $app_name }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Map showing users of the Leaflet mapping library" />
    <meta name="keywords" content="leaflet, users, map, javascript, cloudmade" />
    <!-- <meta name="author" content="Bryan R. McBride, GISP - http://bryanmcbride.com" /> -->

    <!-- Le styles -->
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/css?family=Norican">
    <link type="text/css" rel="stylesheet" href="/vendor/map/assets/bootstrap/css/bootstrap.css">
    <link type="text/css" rel="stylesheet" href="/vendor/map/assets/leaflet/leaflet.css" />
    <!--[if lte IE 8]><link type="text/css" rel="stylesheet" href="assets/leaflet/leaflet.ie.css" /><![endif]-->
    <link type="text/css" rel="stylesheet" href="/vendor/map/assets/leaflet/plugins/leaflet.markercluster/MarkerCluster.css" />
    <link type="text/css" rel="stylesheet" href="/vendor/map/assets/leaflet/plugins/leaflet.markercluster/MarkerCluster.Default.css" />
    <style type="text/css">
      html, body {
        margin: 0;
        padding: 0;
        height: 100%;
        width: 100%;
        position: absolute;
        overflow:hidden;
      }

        iframe {
            display: block;
            background: #000;
            border: none;
            height: 200px;
            width: 300px;
			overflow:hidden;
        }
      #map {
        margin-top:40px;
        width:100%;
        height:100%;
      }
      #loading {
        position: absolute;
        width: 220px;
        height: 19px;
        top: 50%;
        left: 50%;
        margin: -10px 0 0 -110px;
        z-index: 20001;
      }
      #loading .loading-indicator {
        height: auto;
        margin: 0;
      }
      .navbar .brand {
        font-size: 25px;
        font-family: 'Norican', serif;
        font-weight: bold;
        color: white;
      }
      .navbar .nav > li > a {
        padding: 13px 10px 11px;
      }
      .navbar .btn, .navbar .btn-group {
        margin-top: 8px;
      }
      .leaflet-popup-content-wrapper, .leaflet-popup-tip {
        background: #f7f7f7;
      }
      .leaflet-control-geoloc {
        background-image: url(/vendor/map/img/location.png);
        -webkit-border-radius: 5px 5px 5px 5px;
        border-radius: 5px 5px 5px 5px;
      }
	  video {
	  object-fit: fill;
	}
    </style>

    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
      <script type="text/javascript">
      WebFontConfig = {
        google: {
            families: ['Norican::latin']
        }
      };
      (function () {
        var wf = document.createElement('script');
        wf.src = ('http:' == document.location.protocol ? 'https' : 'http') + '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
      })();
      </script>
    <![endif]-->
  </head>

  <body>

    <div class="navbar navbar-inverse navbar-fixed-top">
      <div class="navbar-inner">
        <div class="container">
          <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </a>
          <!--<a class="brand" href="#" onclick="return false;">GFYS Covid</a>-->
          <div class="nav-collapse">
            <ul class="nav">
              <!--<li><a href="#" onclick="$('#splashModal').modal('show');"><i class="icon-leaf icon-white"></i> Pilih Mode</a></li>-->
              <!-- <li><a href="#" onclick="$('#contactModal').modal('show'); return false;"><i class="icon-envelope icon-white"></i> Contact Me</a></li>
              <li><a href="http://github.com/bmcbride/leaflet-users-map" target="_blank"><i class="icon-download icon-white"></i> GitHub Repo</a></li>
              <li><a href="http://leafletjs.com/" target="_blank"><i class="icon-leaf icon-white"></i> Leaflet</a></li>-->
            </ul> 
            <!-- <form class="navbar-form pull-right">
               <span style="padding-right: 20px;"><a class='btn btn-primary btn-small' data-toggle="modal" href="#addmeModal"><i class="icon-plus-sign icon-white"></i> Tambah CCTV</a></span>
               <span><a class='btn btn-danger btn-small' data-toggle="modal" href="#removemeModal"><i class="icon-minus-sign icon-white"></i> Hapus CCTV</a></span>
            </form> -->
          </div>
        </div>
      </div>
    </div>
	
	<div class="modal hide fade" id="splashModal">
      <div class="modal-header">
        <a class="close" data-dismiss="modal">×</a>
        <!--<img src="img/welcome.png" style="margin-top:-15px;" />-->
      </div>
	  <p style="text-align:center;margin-bottom:-20px;"><small>Pilih Mode :</small></p>
      <div class="modal-body">
			<p><a href="#" onclick="$('#splashModal').modal('hide');" class="btn " >Mode Peta</a></p>
			<img src="/vendor/map/img/previewpeta.png" style="margin-bottom:10px;" onclick="$('#splashModal').modal('hide');"/>
			<p><a href="https://cctv.wahyu.top/grid" class="btn ">Mode Tabel</a></p>
			<img src="/vendor/map/img/previewtabel.png" style="margin-bottom:10px;" onclick="window.location.href='https://cctv.wahyu.top/grid'"/>
      </div>
	   <div class="modal-footer">
		<p>Tetap utamakan keselamatan dalam berkendara</p>
	  </div>
    </div>

    <div class="modal hide fade" id="aboutModal">
      <div class="modal-header">
        <a class="close" data-dismiss="modal">×</a>
        <h5 id="judul-header-iklan">Peta Pantau CCTV !</h5>
      </div>
      <div id="isi-iklan" class="modal-body">
		<p>Tetap utamakan keselamatan dalam berkendara</p>
	  </div>
    </div>

    <div class="modal hide fade" id="contactModal">
      <div class="modal-header">
        <a class="close" data-dismiss="modal">×</a>
        <h3>Contact Me!</h3>
      </div>
      <div class="modal-body">
        <p><strong>Email:</strong> windraman(at)gmail(dot)com</p>
        <p><strong>Twitter:</strong> <a href="https://twitter.com/#!/windraman">@windraman</a></p>
      </div>
    </div>

    <div class="modal hide fade" id="addmeModal">
      <div class="modal-header">
        <a class="close" data-dismiss="modal">×</a>
        <h3>Add me to the map!</h3>
      </div>
      <div class="modal-body">
        <p>Click on the Go! button below to get started.</p>
        <p>Navigate to your desired location and click on the map to drop a marker and submit your information.</p>
      </div>
      <div class="modal-footer">
        <a href="#" onclick="$('#addmeModal').modal('hide'); initRegistration(); return false;" class="btn btn-primary">Go!</a>
      </div>
    </div>

    <div id="map"></div>
    <div id="loading-mask" class="modal-backdrop" style="display:none;"></div>
    <div id="loading" style="display:none;">
        <div class="loading-indicator">
            <img src="/vendor/map/img/ajax-loader.gif">
        </div>
    </div>

    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.min.js"></script>
    <script type="text/javascript" src="/vendor/map/assets/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="/vendor/map/assets/leaflet/leaflet.js"></script>
    <script type="text/javascript" src="/vendor/map/assets/leaflet/plugins/leaflet.markercluster/leaflet.markercluster.js"></script>
	
	 <!-- <link href="video-js.min.css" rel="stylesheet"> -->
	<!-- <script src="video.min.js"></script> -->
	<!-- <script src="videojs-contrib-hls.min.js"></script> -->
	<!-- <script src="videojs.imageOverlay.js"></script> -->
	<!-- <link href="videojs.imageOverlay.css" rel="stylesheet"> -->

    <script type="text/javascript">
    
      var getUrlParameter = function getUrlParameter(sParam) {
            var sPageURL = window.location.search.substring(1),
                sURLVariables = sPageURL.split('&'),
                sParameterName,
                i;
        
            for (i = 0; i < sURLVariables.length; i++) {
                sParameterName = sURLVariables[i].split('=');
        
                if (sParameterName[0] === sParam) {
                    var obj = { Title: 'bahandap', Url: 'https://banjarbarukota.go.id/h/' + sParameterName[1] };
                    //alert(obj.Url);
                    window.history.replaceState("string","Bahandap" , "");
                    
                    return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
                }
            }
            
            
        };
        
      var map, newUser, users, mapquest, firstLoad, videofirst, positive, cure;
	  
	  var conn1 = "https://siapkk.banjarbarukota.go.id/api/data_covid_by_gps";

      firstLoad = true;
	  videofirst = true;

      //users = new L.FeatureGroup();
      users = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: false, zoomToBoundsOnClick: true});
      newUser = new L.LayerGroup();
      positive = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: false, zoomToBoundsOnClick: true});
      cure = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: false, zoomToBoundsOnClick: true});

      mapquest = new L.TileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        maxZoom: 18,
        attribution: 'Coding with love by <a href="instagram://user?username=wahyu.indraman">WAHYU.INDRAMAN</a>.'
      });

      map = new L.Map('map', {
        center: new L.LatLng(-3.440513, 114.83058),
        zoom: 14,
        drawControl: true,
        layers: [mapquest, users, newUser, positive, cure]
      });
      
      L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
         attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
     }).addTo(map);

      // GeoLocation Control
      function geoLocate() {
        map.locate({setView: true, maxZoom: 18});
      }
      var geolocControl = new L.control({
        position: 'topright'
      });
      geolocControl.onAdd = function (map) {
        var div = L.DomUtil.create('div', 'leaflet-control-zoom leaflet-control');
        div.innerHTML = '<a class="leaflet-control-geoloc" href="#" onclick="geoLocate(); return false;" title="My location"></a>';
        return div;
      };
      
      map.addControl(geolocControl);
      map.addControl(new L.Control.Scale());

      //map.locate({setView: true, maxZoom: 3});

      $(document).ready(function() {
        $.ajaxSetup({cache:false});
        $('#map').css('height', ($(window).height() - 40));
        
        //getUsers(conn1);
		//$('#splashModal').modal('show');
      });

      $(window).resize(function () {
        $('#map').css('height', ($(window).height() - 40));
      }).resize();

      function geoLocate() {
        map.locate({setView: true, maxZoom: 18});
      }

      function initRegistration() {
        map.addEventListener('click', onMapClick);
        $('#map').css('cursor', 'crosshair');
        return false;
      }

      function cancelRegistration() {
        newUser.clearLayers();
        $('#map').css('cursor', '');
        map.removeEventListener('click', onMapClick);
      }
	  
	 var videopop;
	  
    function onMarkerClick(e) {
           
           hist = this.options.history;
           var lihist = '<ul  class="list-group">';
           for (i = 0; i < hist.length; i++) {
                var d = new Date(hist[i].tanggal);
            	lihist += '<li class="list-group-item">' + hist[i].status + ' ' + d.toLocaleString("id-ID",{dateStyle:"short"}) + '</li>';
            }
		    
		   lihist += '</ul>';
		   //console.log(lihist);
		   videopop = '<div style="font-weight: normal;"><h5>'+this.options.title+'</h5><p>'+this.options.desc+'</p><p>RT : '+this.options.rt+'</p><p>RW : '+this.options.rw+'</p><p>Kecamatan : '+this.options.kecamatan+'</p><p>Kelurahan : '+this.options.kelurahan+'</p><p>Umur : '+this.options.umur+'</p>'+lihist+'</div><p>Ket : '+this.options.ket+'</p>';
	
		   this._popup.setContent( videopop );	
			
	}
	
		
	function cekStatus(name){
		  var stats = null;
		  $.ajax({
			url: "../../cctv/hls/" + name + ".m3u8",
			type: "GET",
			async: false,
			cache: false,
			timeout: 3000,
			success: function(xml, textStatus, xhr) {
				//console.log(arguments);
				//console.log(name + " stat : " + xhr.status);
			},
			complete: function(xhr, textStatus) {				
				stats = xhr.status;				
			}		
		});
		 return stats;
	  }

      function getUsers(conn) {
	//	alert('panggil');
	    var kunci = getUrlParameter('kunci');
	    
	    positive.clearLayers();
        $.getJSON(conn + "?kunci="+kunci, function (data) {
            
			//if (conn == conn1){
				var cata = data.data;
			//}else {
				//var cata = data;
			//}
		  
		  //if(data.api_status=="1"){
              for (var i = 0; i < cata.length; i++) {
                var location = new L.LatLng(cata[i].lat, cata[i].lon);
                var name = cata[i].warga_bjb_id;
                var input = cata[i].kecamatan;
    			var deskripsi = cata[i].alamat;
    			var rt = cata[i].rt;
    			var rw = cata[i].rt;
    			var kecamatan = cata[i].kecamatan;
    			var kelurahan = cata[i].kelurahan;
    			var history = cata[i].history;
    			var umur = cata[i].umur;
    			var status = cata[i].last_status;
    			var ket = cata[i].keterangan;
    			//console.log(cata[i].history);
                var title = "<div style='text-align: center; margin-left: auto; margin-right: auto;'><div style='font-size: 18px; color: #0078A8;'>"+ deskripsi + "</div></div>";
    			var myIcon = L.icon({
    				iconUrl: 'https://siapkk.banjarbarukota.go.id/'+cata[i].last_status_icon,
    				iconSize: [60, 60],
    				iconAnchor: [20, 35],
    				popupAnchor: [3, -20],
    			//	shadowUrl: 'cvdshadow.png',
    				shadowSize: [60, 60],
    				shadowAnchor: [20, 35]
    			});
    			
                var marker = new L.Marker(location, {
                  title: name,
    			  desc : deskripsi,
    			  icon: myIcon,
    			  rt: rt,
    			  rw: rw,
    			  kecamatan: kecamatan,
    			  kelurahan: kelurahan,
    			  history:history,
    			  umur:umur,
    			  ket:ket
                });	
    			
    			
                marker.bindPopup("<div id='pop' style='text-align: center; margin-left: auto; margin-right: auto;width:500;height:300px'>"+ title +"</div>", {maxWidth: '600'});
                
                //if(status=='Positif')
        			positive.addLayer(marker);
        // 		else{
        // 		    cure.addLayer(marker);
        // 		}
    			
    			marker.on('click', onMarkerClick );
    			
    			
              }
		  //}else{
		  //    //positive.clearLayers();
		  //   // window.location.replace("https://banjarbarukota.go.id/h/"+kunci);
		  //    //alert("Link expired !");
		  //}
        }).complete(function() {
          if (firstLoad == true) {
            map.fitBounds(positive.getBounds());
            firstLoad = false;
          };
        }).error(function() {
            positive.clearLayers();
			if(conn==conn1){
				//getUsers(conn1);
			}else{
				alert("Gagal Mengambil data, Silakan Refresh Browser Anda");
			}
        });
      }
	  
	  function test(conn){
		 $.ajax({
            url: conn,
            type: "GET",
			dataType: "json",
            success: function (response) {
                var resp = JSON.parse(response)
                alert(resp.status);
            },
            error: function (xhr, status) {
                alert("error");
            }
        });
	  }
	  


      function onMapClick(e) {
        var markerLocation = new L.LatLng(e.latlng.lat, e.latlng.lng);
        var marker = new L.Marker(markerLocation);
        newUser.clearLayers();
        newUser.addLayer(marker);
        var form =  '<form id="inputform" enctype="multipart/form-data" class="well">'+
              '<label><strong>Name:</strong> <i>marker title</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="name" name="name" />'+
              '<label><strong>Input:</strong> <i>never shared</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="input" name="input" />'+
			  '<label><strong>Deskripsi:</strong> <i>marker description</i></label>'+
              '<input type="text" class="span3" placeholder="Required" id="deskripsi" name="deskripsi" />'+
              '<input style="display: none;" type="text" id="lat" name="lat" value="'+e.latlng.lat.toFixed(6)+'" />'+
              '<input style="display: none;" type="text" id="lng" name="lng" value="'+e.latlng.lng.toFixed(6)+'" /><br><br>'+
              '<div class="row-fluid">'+
                '<div class="span6" style="text-align:center;"><button type="button" class="btn" onclick="cancelRegistration()">Cancel</button></div>'+
                '<div class="span6" style="text-align:center;"><button type="button" class="btn btn-primary" onclick="insertStream()">Submit</button></div>'+
              '</div>'+
              '</form>';
        marker.bindPopup(form).openPopup();
      }
	 
	  
	
	function bindEvent(element, eventName, eventHandler) {
            if (element.addEventListener) {
                element.addEventListener(eventName, eventHandler, false);
            } else if (element.attachEvent) {
                element.attachEvent('on' + eventName, eventHandler);
            }
        }
	
	bindEvent(window, 'message', function (e) {
	        //alert(e.data);
            //videopop.innerHTML = e.data;
           // window.location.href="https://wa.me/"+e.data;
        });
        
        
    </script>

  </body>
</html>

