<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
     <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

     <title>{{ $profile->name }}</title>

     <style type="text/css">
        * { margin: 0; padding: 0; }
        body { font: 16px Helvetica, Sans-Serif; line-height: 24px; background: url(images/noise.jpg); }
        .clear { clear: both; }
        #page-wrap { width: 800px; margin: 40px auto 60px; }
        #pic { float: right; margin: -30px 0 0 0; }
        h1 { margin: 0 0 16px 0; padding: 0 0 16px 0; font-size: 42px; font-weight: bold; letter-spacing: -2px; border-bottom: 1px solid #999; }
        h2 { font-size: 20px; margin: 0 0 6px 0; position: relative; }
        h2 span { position: absolute; bottom: 0; right: 0; font-style: italic; font-family: Georgia, Serif; font-size: 16px; color: #999; font-weight: normal; }
        p { margin: 0 0 16px 0; }
        a { color: #999; text-decoration: none; border-bottom: 1px dotted #999; }
        a:hover { border-bottom-style: solid; color: black; }
        ul { margin: 0 0 32px 17px; }
        #objective { width: 500px; float: left; }
        #objective p { font-family: Georgia, Serif; font-style: italic; color: #666; }
        dt { font-style: italic; font-weight: bold; font-size: 18px; text-align: right; padding: 0 26px 0 0; width: 150px; float: left; height: 100px; border-right: 1px solid #999;  }
        dd { width: 600px; float: right; }
        dd.clear { float: none; margin: 0; height: 15px; }
     </style>
</head>

<body>

    <div id="page-wrap">
    
        <img src="images/cthulu.png" alt="Photo of Cthulu" id="pic" />
    
        <div id="contact-info" class="vcard">
        
            <!-- Microformats! -->
        
            <h1 class="fn">{{ $profile->name }}</h1>
        
            <p>
                NIK : <span class="tel">{{ $profile->nik }}</span><br />
                Alamat : <span class="tel">{{ $profile->alamat . ' RT.' . $profile->rt . ' RW.' . $profile->rw . ' Kel.' . $profile->kelurahan . ' Kec.' . $profile->kecamatan }}</span><br />
                Email : <a class="email" href="mailto:greatoldone@lovecraft.com">greatoldone@lovecraft.com</a>
            </p>
        </div>
                
        <!--<div id="objective">-->
        <!--    <p>-->
        <!--        I am an outgoing and energetic (ask anybody) young professional, seeking a -->
        <!--        career that fits my professional skills, personality, and murderous tendencies. -->
        <!--        My squid-like head is a masterful problem solver and inspires fear in who gaze upon it. -->
        <!--        I can bring world domination to your organization. -->
        <!--    </p>-->
        <!--</div>-->
        
        <div class="clear"></div>
        
        <dl>
            <dd class="clear"></dd>
            
            <dt>Pemilik Usaha</dt>
            <dd>
                <table>
                @if($pemilik)
                <tr>
                    <td ><strong>No IUMK/NIB</strong></td>
                    @if($pemilik->no_iumk == NULL)
                        <td><div class="text-danger">*Anda belum mendaftarkan No IUMK atau NIB</div></td>
                    @else
                        <td>{{ $pemilik->no_iumk }}</td>
                    @endif
                </tr>
                <tr>
                    <td >
                        <strong>NPWP</strong>
                    </td>
                    @if($pemilik->no_npwp == NULL)
                        <td><div class="text-danger">*Anda belum mendaftarkan No NPWP</div></td>
                    @else
                         <td>{{ $pemilik->no_npwp }}</td>
                    @endif
                    
                </tr>
                <tr>
                    <td><strong>No Telp</strong></td>
                    @if($pemilik->no_telp == NULL)
                        <td><div class="text-danger">*Anda belum mendaftarkan No Telepon</div></td>
                    @else
                         <td>{{ $pemilik->no_telp }}</td>
                    @endif
                    
                </tr>
                
                @else
                <tr>
                    <!--<td><strong>Mendaftar </strong></td>-->
                    <td>
                        <form class="form-horizontal" method="post" id="form_pemilik" enctype="multipart/form-data" action="{{ CRUDBooster::mainPath('daftar-pemilik/'. $profile->id_warga ) }}">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                            <div class="col-sm-1">
                                <input type="submit" name="submit_mpwp" value="Sebagai Pengusaha" class="btn btn-success">
                            </div>     
                        </form>
                    </td>
                </tr>
                @endif
                </table>
            </dd>
            
            <dd class="clear"></dd>
            
            <dt>Usaha</dt>
            <dd>
                <table class="table table-striped">
              <thead>
                <tr>
                  <th scope="col">Nama</th>
                  <th scope="col">Bidang</th>
                  <th scope="col">Alamat</th>
                  <th scope="col">Jumlah Karyawan</th>
                  <th scope="col">Omset</th>
                </tr>
              </thead>
              <tbody>
                @foreach($usaha as $ush)
                <tr>
                  <td>{{ $ush->nama_usaha }}</td>
                  <td>{{ $ush->bidang_usaha }}</td>
                  <td>{{ $ush->alamat_usaha }}</td>
                  <td>{{ intval($ush->j_kary_l) + intval($ush->j_kary_p) . ' orang'  }}</td>
                  <td>{{ 'Rp ' .  $ush->omset }}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
            </dd>
            
            <dd class="clear"></dd>
            
            <dt>Experience</dt>
            <dd>
                <h2>Doomsday Cult <span>Leader/Overlord - Baton Rogue, LA - 1926-2010</span></h2>
                <ul>
                    <li>Inspired and won highest peasant death competition among servants</li>
                    <li>Helped coordinate managers to grow cult following</li>
                    <li>Provided untimely deaths to all who opposed</li>
                </ul>
                
                <h2>The Watering Hole <span>Bartender/Server - Milwaukee, WI - 2009</span></h2>
                <ul>
                    <li>Worked on grass-roots promotional campaigns</li>
                    <li>Reduced theft and property damage percentages</li>
                    <li>Janitorial work, Laundry</li>
                </ul> 
            </dd>
            
            <dd class="clear"></dd>
            
            <dt>Hobbies</dt>
            <dd>World Domination, Deep Sea Diving, Murder Most Foul</dd>
            
            <dd class="clear"></dd>
            
            <dt>References</dt>
            <dd>Available on request</dd>
            
            <dd class="clear"></dd>
        </dl>
        
        <div class="clear"></div>
    
    </div>

</body>

</html>