<?php
setlocale(LC_ALL, 'IND');
?>

@extends('crudbooster::admin_template')


@section('content')
        <div class='panel panel-default' >
            <div class='panel-heading'><strong>{{ $modul->name }}  {{ $perusahaan->nama_perusahaan }} ({{$surat->id}})</strong></div>
        
                <div class='panel-body'>
                    @if($terkirim)
                    <p style="color:red;">Permohonan ini sudah di proses !</p>
                    @endif
                    <form method='post' action='{{CRUDBooster::mainpath("teruskan/".$surat->id)}}' name="nomorform" id="nomorform" onsubmit="return validateForm()">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                        <input type="hidden" name="id" value="{{ $id }}"/>
                        <input type="hidden" name="parent_table" value="{{ $surat->parent_table }}"/>
                        <input type="hidden" name="parent_id" value="{{ $surat->parent_id }}"/>
                        <input type="hidden" name="jenis_surat_id" value="{{ $surat->jenis_surat_id }}"/>
                        
                        <input type="hidden" name="nomor_terakhir" value="{{ ((int)$jenis_surat->nomor_terakhir+1) }}"/>
                        
                        
                        <div class="form-group">
                            <label for="nomor">Nomor Surat *</label>
                            <input autocomplete='off' type="text" class="form-control" name='nomor' form="nomorform" required  id="nomor" value="{{ $jenis_surat->kode_depan . ((int)$jenis_surat->nomor_terakhir+1) . $jenis_surat->kode_belakang }}"/>
                        </div>

                        
                        <div class="form-group">
                            <label for="pejabat_id">Pejabat Penandatangan *</label>
                            <select name="pejabat_id" required="required" form="nomorform"  class="form-control form-select-lg mb-3" id="pejabat_id" >
                              <option selected value=0>Pilih pejabat *</option>
                              @foreach($pejabat as $pj)
                                <option value="{{ $pj->id }}">{{ $pj->nama_pejabat }}( {{ $pj->jabatan  }} ) - NIP. {{ $pj->nip_pejabat }}</option>
                              @endforeach
                            </select>
                        </div>

                        <div class='form-group form-datepicker {{$header_group_class}} {{ ($errors->first($name))?"has-error":"" }}' id='form-group-{{$name}}'
                            style="{{@$form['style']}}">
                            <label for="nomor">Tanggal Surat</label>
                            <div class="input-group">
                                <span class="input-group-addon open-datetimepicker"><a><i class='fa fa-calendar '></i></a></span>
                                <input type='text' title="{{$form['label']}}" form="nomorform"
                                    {{$readonly}} {!!$placeholder!!} {{$disabled}} class='form-control notfocus input_date' name="tanggal" id="tanggal"
                                    value=''/>
                            </div>
                        </div>
                        @if($surat->parent_table=='perjanjian_kerja_waktu_tertentu')
                        <div class="col-sm-12">
                        	<div id="form-formatpenomoran">
                                <h4>Format Penomoran Daftar Pekerja</h4>
                                <div class="">
                        			<div class="row">
                        				<div class="col-sm-10">
                        					<div class="">
                        						<div class="col-sm-3 form-group" id="form-group-kode_depan" style="padding-right: 30px !important">
                        							<div>
                        								<label class="control-label ">Kode Depan
                        									 <span class="text-danger" title="This field is required">*</span>
                        								</label>
                        							</div>
                        							<input type="text" title="Kode Depan" required="1" class="form-control " name="nomor_depan_child" id="nomor_depan_child" value="{{ $parent->nomor_depan_child }}", "placeholder"=>"PK."
                        							<div class="text-danger"></div>
                        							<p class="help-block"></p>
                        						</div>                                                 
                        						<div class="col-sm-3 form-group" id="form-group-nomor_terakhir" style="padding-right: 30px !important">
                        							<div>
                        								<label class="control-label ">Nomor Terakhir
                        									 <span class="text-danger" title="This field is required">*</span>
                        								</label>
                        							</div>
                        							<input id="nomor_terakhir_child" type="number" required="1" min="0" name="nomor_terakhir_child" class="form-control " value="{{ $parent->nomor_terakhir_child }}">
                        						</div>
                        						<div class="col-sm-3 form-group" id="form-group-kode_belakang" style="padding-right: 30px !important">
                        							<div>
                        							<label class="control-label ">Kode Belakang
                        								 <span class="text-danger" title="This field is required">*</span>
                        							</label>
                        							</div>
                        							<input type="text" title="Kode Belakang" required="1" class="form-control " name="nomor_belakang_child" id="nomor_belakang_child" value="{{ $parent->nomor_belakang_child }}">
                        							<div class="text-danger"></div>
                        						</div>
                        						
                        						<p class="help-block"></p>
                        						</div>
                        					</div>
                        				</div>
                        			</div>
                        		</div>
                        	</div>
                        </div>
                        @endif
                    	<div class='form-group'>
                    	    <a type="button" class='btn btn-default'  href='{{ CRUDBooster::adminPath('surat_idv') }}' style="margin-left:15px"><i class='fa fa-chevron-circle-left'></i> Kembali</a>
                    		<input type="submit" class='btn btn-info' value="BUAT DOKUMEN" style="margin-left:15px"/>
                    		
                    		<!--@if($terkirim)-->
                    		<!--    <a type="button" class='btn btn-default'  href='{{ CRUDBooster::adminPath('surat_idv/') }}' style="margin-left:15px"><i class='fa fa-chevron-circle-left'></i> Perbaharui</a>-->
                    		<!--@endif-->
                    	</div>
                    </form>
                </div>
            
      </div>
@endsection

@push('bottom')

    

    @if (App::getLocale() != 'en')
        <script src="{{ asset ('vendor/crudbooster/assets/adminlte/plugins/datepicker/locales/bootstrap-datepicker.'.App::getLocale().'.js') }}"
                charset="UTF-8"></script>
    @endif
    <script type="text/javascript">

    
        var lang = '{{App::getLocale()}}';
        $(function () {
            $('.input_date').datepicker({
                format: 'yyyy-mm-dd',
                @if (in_array(App::getLocale(), ['ar', 'fa']))
                rtl: true,
                @endif
                language: lang
            });

            $('.open-datetimepicker').click(function () {
                $(this).next('.input_date').datepicker('show');
            });

        });

        $('#nomorform').on('submit', function(){
            if($('#pejabat_id').val()==0){
                alert("Pilih Pejabat Penandatangan !");
                return false;
            }
        })

    </script>
@endpush