@extends('crudbooster::admin_template_no_side_bar')

@section('content')
@if(Session::has('download.in.the.next.request'))
    <a class="btn btn-success" href="{{ Session::get('download.in.the.next.request') }}" target="_blank">Download file PDF</a>
@endif
<div class="box">
    
    <div class="box-header">
        UMKM
    </div>
    @if(CRUDBooster::myPrivilegeId()==2)
    <div class="row">

    	 <div id="area1" class="col-sm-3 connectedSortable ui-sortable"  onclick="location.href=' {{CRUDBooster::adminPath('umkm_usaha/add')}}'">
    			
    			<div id="" class="border-box">
    
    			<div class="small-box bg-blue	">
    				<div class="inner inner-box">
    					<h3><i class="fa fa-plus"></i></h3>
    					<p>Daftarkan Usaha</p>
    				</div>
    
    			</div>
    
    		</div>	
    	</div>
    	
    	 <div id="area2" class="col-sm-3 connectedSortable ui-sortable"  onclick="location.href=' {{CRUDBooster::adminPath('umkm_usaha')}}'">
    			
    			<div id="" class="border-box">
    
    			<div class="small-box bg-green	">
    				<div class="inner inner-box">
    					<h3><i class="fa fa-shopping-bag"></i></h3>
    					<p>Usaha Saya</p>
    				</div>
    
    			</div>
    
    		</div>	
    	</div>
    	
    	<div id="area3" class="col-sm-3 connectedSortable ui-sortable"  onclick="location.href=' {{CRUDBooster::adminPath('surat_reg_pelatihan/sistem-pelatihan')}}'">
    			
    			<div id="" class="border-box">
    
    			<div class="small-box bg-aqua	">
    				<div class="inner inner-box">
    					<h3><i class="fa fa-train"></i></h3>
    					<p>Pelatihan</p>
    				</div>
    
    			</div>
    
    		</div>	
    	</div>
    	
    	<div id="area3" class="col-sm-3 connectedSortable ui-sortable"  onclick="location.href=' {{CRUDBooster::adminPath('umkm_bantuan/sistem-bantuan')}}'">
    			
    			<div id="" class="border-box">
    
    			<div class="small-box bg-yellow	">
    				<div class="inner inner-box">
    					<h3><i class="fa fa-heart"></i></h3>
    					<p>Bantuan</p>
    				</div>
    
    			</div>
    
    		</div>	
    	</div>
    	
    	<!--<div id="area3" class="col-sm-3 connectedSortable ui-sortable"  onclick="location.href=' {{CRUDBooster::adminPath('surat_permohonan_tte/add')}}'">-->
    			
    	<!--		<div id="" class="border-box">-->
    
    	<!--		<div class="small-box bg-aqua	">-->
    	<!--			<div class="inner inner-box">-->
    	<!--				<h3><i class="fa fa-file"></i></h3>-->
    	<!--				<p>Permohonan TTE</p>-->
    	<!--			</div>-->
    
    	<!--		</div>-->
    
    	<!--	</div>	-->
    	<!--</div>-->

     <!--   <div id="area3" class="col-sm-3 connectedSortable ui-sortable"  onclick="location.href=' {{CRUDBooster::adminPath('wbs/add')}}'">-->
    			
    	<!--		<div id="" class="border-box">-->
    
    	<!--		<div class="small-box bg-red	">-->
    	<!--			<div class="inner inner-box">-->
    	<!--				<h3><i class="fa fa-file"></i></h3>-->
    	<!--				<p>Pengaduan</p>-->
    	<!--			</div>-->
    
    	<!--		</div>-->
    
    	<!--	</div>	-->
    	<!--</div> -->
    
    </div>
    @endif

</div>



<div class="box">
    <div class="box-header">
        Profil Pemilik
    </div>
     <table id="table-detail" class="table table-striped">
        <tbody>
            <tr>
                <td ><strong>NIK</strong></td>
                <td>{{ $profile->nik }}</td>
            </tr>
            <tr>
                <td ><strong>Nama</strong></td>
                <td>{{ $profile->name }}</td>
            </tr>
            <tr>
                <td ><strong>Alamat</strong></td>
                <td>{{ $profile->alamat . ' RT.' . $profile->rt . ' RW.' . $profile->rw . ' Kel.' . $profile->kelurahan . ' Kec.' . $profile->kecamatan  }}</td>
            </tr>
            @if($pemilik)
            <tr>
                <td ><strong>No IUMK/NIB</strong></td>
                <!--<td>{{ $pemilik->no_iumk }}</td>-->
                <td>
                    <form class="form-horizontal" method="post" id="form_iumk" enctype="multipart/form-data" action="{{ CRUDBooster::mainPath('simpan-iumk/'. $pemilik->id ) }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                        <div class="col-sm-4">
                            <input type="text" id="no_iumk" title="No IUMK/NIB" class="form-control" name="no_iumk" value={{ $pemilik->no_iumk }}>
                            @if($pemilik->no_iumk == NULL)
                                <div class="text-danger">*Anda belum mendaftarkan No IUMK atau NIB</div>
                            @endif
                            @if (\Session::has('iumk_success'))
                                <div class="text-success">{!! \Session::get('iumk_success') !!}</div>
                            @endif
                        </div>
                        <div class="col-sm-1">
                            <input type="submit" name="submit_iumk" value="Ubah" class="btn btn-success">
                        </div>   
                    </form>
                </td>
            </tr>
            <tr>
                <td ><strong>NPWP</strong>
                </td>
                <td>
                   <form class="form-horizontal" method="post" id="form_npwp" enctype="multipart/form-data" action="{{ CRUDBooster::mainPath('simpan-npwp/'. $pemilik->id ) }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                        <div class="col-sm-4">
                            <input type="text" id="no_npwp" title="No NPWP" class="form-control" name="no_npwp" value={{ $pemilik->no_npwp }}>
                            @if($pemilik->no_npwp == NULL)
                                <div class="text-danger">*Anda belum mendaftarkan No NPWP</div>
                            @endif
                             @if (\Session::has('npwp_success'))
                                <div class="text-success">{!! \Session::get('npwp_success') !!}</div>
                            @endif
                        </div>
                        <div class="col-sm-1">
                            <input type="submit" name="submit_mpwp" value="Ubah" class="btn btn-success">
                        </div>     
                    </form>
                </td>
            </tr>
            <tr>
                <td><strong>No Telp</strong></td>
                <td>
                    <form class="form-horizontal" method="post" id="form_telp" enctype="multipart/form-data" action="{{ CRUDBooster::mainPath('simpan-telp/'. $pemilik->id ) }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                        <div class="col-sm-4">
                            <input type="text" id="no_telp" title="No NPWP" class="form-control" name="no_telp" value={{ $pemilik->no_telp }}>
                            @if($pemilik->no_telp == NULL)
                                <div class="text-danger">*Anda belum mendaftarkan No Telepon</div>
                            @endif
                            @if (\Session::has('telp_success'))
                                <div class="text-success">{!! \Session::get('telp_success') !!}</div>
                            @endif
                        </div>
                        <div class="col-sm-1">
                            <input type="submit" name="submit_mpwp" value="Ubah" class="btn btn-success">
                        </div>     
                    </form>
                </td>
            </tr>
            
            @else
            <tr>
                <!--<td><strong>Mendaftar </strong></td>-->
                <td>
                    <form class="form-horizontal" method="post" id="form_pemilik" enctype="multipart/form-data" action="{{ CRUDBooster::mainPath('daftar-pemilik/'. $profile->id_warga ) }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                        <div class="col-sm-1">
                            <input type="submit" name="submit_mpwp" value="Sebagai Pengusaha" class="btn btn-success">
                        </div>     
                    </form>
                </td>
            </tr>
            @endif
            <tr>
                <td ><strong>Photo</strong></td>
                <td><img src="{{'https://siapkk.banjarbarukota.go.id/' . $profile->photo}}" style="max-width:160px"></td>
            </tr>
        </tbody>
    </table>
</div>



<div class="box">
    <div class="box-header">
        Summary Usaha Saya
    </div>
        <table class="table table-striped">
          <thead>
            <tr>
              <th scope="col">Nama Usaha</th>
              <th scope="col">Bidang Usaha</th>
              <th scope="col">Alamat Usaha</th>
              <th scope="col">Jumlah Karyawan</th>
              <th scope="col">Omset</th>
            </tr>
          </thead>
          <tbody>
            @foreach($usaha as $ush)
            <tr>
              <td>{{ $ush->nama_usaha }}</td>
              <td>{{ $ush->bidang_usaha }}</td>
              <td>{{ $ush->alamat_usaha }}</td>
              <td>{{ intval($ush->j_kary_l) + intval($ush->j_kary_p) . ' orang'  }}</td>
              <td>{{ 'Rp ' .  $ush->omset }}</td>
            </tr>
            @endforeach
          </tbody>
        </table>
</div>

<div class="box">
    <div class="box-header">
        Pelatihan yang telah diikuti
    </div>
        <table class="table table-striped">
          <thead>
            <tr>
              <th scope="col">Nama Pelatihan</th>
              <th scope="col">Penyelenggara</th>
              <th scope="col">Tanggal</th>
              <th scope="col">Keterangan</th>
            </tr>
          </thead>
          <tbody>
            @foreach($pelatihan as $plt)
            <tr>
              <td>{{ $plt->nama_pelatihan }}</td>
              <td>{{ $plt->penyelenggara }}</td>
              <td>{{ $plt->tanggal_mulai }}</td>
              <td>{!! $plt->keterangan !!}</td>
            </tr>
            @endforeach
          </tbody>
        </table>
</div>

<div class="box">
    <div class="box-header">
        Bantuan yang diterima
    </div>
        <table class="table table-striped">
          <thead>
            <tr>
              <th scope="col">Nama Bantuan</th>
              <th scope="col">Pemberi Bantuan</th>
              <th scope="col">Tanggal</th>
              <th scope="col">Keterangan</th>
            </tr>
          </thead>
          <tbody>
            @foreach($bantuan as $blt)
            <tr>
              <td>{{ $blt->bantuan }}</td>
              <td>{{ $blt->pemberi_bantuan }}</td>
              <td>{{ $blt->tanggal }}</td>
              <td>{!! $blt->keterangan !!}</td>
            </tr>
            @endforeach
          </tbody>
        </table>
</div>

<a href="{{ CRUDBooster::mainPath('cetak-profil/'. $pemilik->id ) }}" class="btn btn-primary">Cetak Profil</a>

<?php
  //var_dump($bantuan);
?>


@endsection