

<section class="profil-usaha">
    <div class="box">
        <div class="box-header">
            Profil Pemilik
        </div>
         <table id="table-detail" class="table table-striped">
            <tbody>
                <tr>
                    <td ><strong>Photo</strong></td>
                    <td><img src="{{'https://siapkk.banjarbarukota.go.id/' . $profile->photo}}" style="max-width:160px"></td>
                </tr>
                <tr>
                    <td ><strong>NIK</strong></td>
                    <td>{{ $profile->nik }}</td>
                </tr>
                <tr>
                    <td ><strong>Nama</strong></td>
                    <td>{{ $profile->name }}</td>
                </tr>
                <tr>
                    <td ><strong>Alamat</strong></td>
                    <td>{{ $profile->alamat . ' RT.' . $profile->rt . ' RW.' . $profile->rw . ' Kel.' . $profile->kelurahan . ' Kec.' . $profile->kecamatan  }}</td>
                </tr>
                @if($pemilik)
                <tr>
                    <td ><strong>No IUMK/NIB</strong></td>
                    @if($pemilik->no_iumk == NULL)
                        <td><div class="text-danger">*Anda belum mendaftarkan No IUMK atau NIB</div></td>
                    @else
                        <td>{{ $pemilik->no_iumk }}</td>
                    @endif
                </tr>
                <tr>
                    <td >
                        <strong>NPWP</strong>
                    </td>
                    @if($pemilik->no_npwp == NULL)
                        <td><div class="text-danger">*Anda belum mendaftarkan No NPWP</div></td>
                    @else
                         <td>{{ $pemilik->no_npwp }}</td>
                    @endif
                    
                </tr>
                <tr>
                    <td><strong>No Telp</strong></td>
                    @if($pemilik->no_telp == NULL)
                        <td><div class="text-danger">*Anda belum mendaftarkan No Telepon</div></td>
                    @else
                         <td>{{ $pemilik->no_telp }}</td>
                    @endif
                    
                </tr>
                
                @else
                <tr>
                    <!--<td><strong>Mendaftar </strong></td>-->
                    <td>
                        <form class="form-horizontal" method="post" id="form_pemilik" enctype="multipart/form-data" action="{{ CRUDBooster::mainPath('daftar-pemilik/'. $profile->id_warga ) }}">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
                            <div class="col-sm-1">
                                <input type="submit" name="submit_mpwp" value="Sebagai Pengusaha" class="btn btn-success">
                            </div>     
                        </form>
                    </td>
                </tr>
                @endif
                
            </tbody>
        </table>
    </div>
    
    
    
    <div class="box">
        <div class="box-header">
            Summary Usaha Saya
        </div>
            <table class="table table-striped">
              <thead>
                <tr>
                  <th scope="col">Nama Usaha</th>
                  <th scope="col">Bidang Usaha</th>
                  <th scope="col">Alamat Usaha</th>
                  <th scope="col">Jumlah Karyawan</th>
                  <th scope="col">Omset</th>
                </tr>
              </thead>
              <tbody>
                @foreach($usaha as $ush)
                <tr>
                  <td>{{ $ush->nama_usaha }}</td>
                  <td>{{ $ush->bidang_usaha }}</td>
                  <td>{{ $ush->alamat_usaha }}</td>
                  <td>{{ intval($ush->j_kary_l) + intval($ush->j_kary_p) . ' orang'  }}</td>
                  <td>{{ 'Rp ' .  $ush->omset }}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
    </div>
    
    <div class="box">
        <div class="box-header">
            Pelatihan yang telah diikuti
        </div>
            <table class="table table-striped">
              <thead>
                <tr>
                  <th scope="col">Nama Pelatihan</th>
                  <th scope="col">Penyelenggara</th>
                  <th scope="col">Tanggal</th>
                  <th scope="col">Keterangan</th>
                </tr>
              </thead>
              <tbody>
                @foreach($pelatihan as $plt)
                <tr>
                  <td>{{ $plt->nama_pelatihan }}</td>
                  <td>{{ $plt->penyelenggara }}</td>
                  <td>{{ $plt->tanggal_mulai }}</td>
                  <td>{!! $plt->keterangan !!}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
    </div>
    
    <div class="box">
        <div class="box-header">
            Bantuan yang diterima
        </div>
            <table class="table table-striped">
              <thead>
                <tr>
                  <th scope="col">Nama Bantuan</th>
                  <th scope="col">Pemberi Bantuan</th>
                  <th scope="col">Tanggal</th>
                  <th scope="col">Keterangan</th>
                </tr>
              </thead>
              <tbody>
                @foreach($bantuan as $blt)
                <tr>
                  <td>{{ $blt->bantuan }}</td>
                  <td>{{ $blt->pemberi_bantuan }}</td>
                  <td>{{ $blt->tanggal }}</td>
                  <td>{!! $blt->keterangan !!}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
    </div>
</section>

<?php
  //var_dump($bantuan);
?>


