<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    <title>Sistem Informasi Layanan Ketenagakerjaan Hubungan Industrial</title>
    <link rel="icon" href="assets/img/banjarbaru.png">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <link href="assets/vendor/aos/aos.css" rel="stylesheet">
    <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
    <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
    <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
    <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

    <link href="assets/css/style.css" rel="stylesheet">
    <style>
        * {box-sizing:border-box}

        /* Slideshow container */
        .slideshow-container {
          max-width: 1000px;
          position: relative;
          margin: auto;
        }
        
        /* Hide the images by default */
        .mySlides {
          display: none;
        }
        
        /* Next & previous buttons */
        .prev, .next {
          cursor: pointer;
          position: absolute;
          top: 50%;
          width: auto;
          margin-top: -22px;
          padding: 16px;
          color: white;
          font-weight: bold;
          font-size: 18px;
          transition: 0.6s ease;
          border-radius: 0 3px 3px 0;
          user-select: none;
        }
        
        /* Position the "next button" to the right */
        .next {
          right: 0;
          border-radius: 3px 0 0 3px;
        }
        
        /* On hover, add a black background color with a little bit see-through */
        .prev:hover, .next:hover {
          background-color: rgba(0,0,0,0.8);
        }
        
        /* Caption text */
        .text {
          color: #f2f2f2;
          font-size: 15px;
          padding: 8px 12px;
          position: absolute;
          bottom: 8px;
          width: 100%;
          text-align: center;
        }
        
        /* Number text (1/3 etc) */
        .numbertext {
          color: #f2f2f2;
          font-size: 12px;
          padding: 8px 12px;
          position: absolute;
          top: 0;
        }
        
        /* The dots/bullets/indicators */
        .dot {
          cursor: pointer;
          height: 15px;
          width: 15px;
          margin: 0 2px;
          background-color: #bbb;
          border-radius: 50%;
          display: inline-block;
          transition: background-color 0.6s ease;
        }
        
        .active, .dot:hover {
          background-color: #717171;
        }
        
        /* Fading animation */
        .fade {
          animation-name: fade;
          animation-duration: 1.5s;
        }
        
        @keyframes fade {
          from {opacity: .4}
          to {opacity: 1}
        }
        
        .cta {
                background: linear-gradient(rgba(81, 103, 143, 0.912), rgba(103, 103, 103, 0.775)), url("{{ $banner->latar }}") fixed center center;
                background-size: 100% 100%;
                padding: 200px 0;
        }
    </style>
</head>

<body>
    <header id="header" class="header fixed-top">
        <div class="container d-flex align-items-center">
            <h1 class="logo me-auto"><img src="assets/img/banjarbaru.png" alt="banjarbaru"><a href="#">SILAKHI</a></h1>

            <nav id="navbar" class="navbar" >
                <ul>
                <li><a class="header-scrolled getstarted scrollto" href="#about">Tentang Kami</a></li>
                <li><a class="header-scrolled getstarted scrollto" href="#services">Layanan Kami</a></li>
                <li><a class="header-scrolled getstarted scrollto" href="#kegiatan">Kegiatan</a></li>
                <li><a class="header-scrolled getstarted scrollto" href="{{ $tutorial->gambar }}?download=1">Tutorial</a></li>
                <li><a class="header-scrolled getstarted scrollto border border-white rounded-5" href="admin/login">Masuk</a></li>
                </ul>
                <i class="bi bi-list mobile-nav-toggle"></i>
            </nav>
        </div>
    </header>

    <section id="cta" class="cta">
        <div class="container">
            <div class="row d-flex align-items-center">
                @if($banner->gambar)
                <div class="col-lg-7 d-flex flex-column justify-content-center pt-4 pt-lg-0 order-2 order-lg-1 aos-init aos-animate">
                    {!! $banner->coding !!}
                </div>
                
                
                <div class="col-lg-5 order-1 order-lg-2 hero-img aos-init aos-animate">
                    <div class="text-center">
                        <img class="img-fluid" data-aos="zoom-in-up" data-aos-delay="100" src="{{ $banner->gambar }}" style="width: 550px;">
                    </div>
                </div>
                @else
                <div class="col-lg-8 d-flex flex-column justify-content-center pt-4 pt-lg-0 order-2 order-lg-1 aos-init aos-animate">
                    {!! $banner->coding !!}
                </div>
                @endif
            </div>
        </div>
    </section>

{{--Section Tentang Kami  --}}
    <section id="about" class="section-bg">
        <div class="container" data-aos="fade-up">

            <div class="section-title">
              <h2>Tentang Kami</h2>
            </div>

            {!! $about->coding !!}

          </div>
    </section>
{{-- Akhir Section Tentang Kami --}}


{{-- Section Layanan Kami --}}
    <section id="services" class="services section-bgg">
        <div class="container" data-aos="fade-up">
            <div class="section-title">
                <h2>Layanan Kami</h2>
                <p>Lengkapi Persyaratan Anda Sebelum Melakukan Pengajuan. Syarat syarat dapat dilihat dibawah ini :</p>
            </div>

            {!! $modal->coding !!}
            <div class="row mb-4">
                <div class="row justify-content-center">
                    @foreach($layanan as $lyn)
                    <div class="col-xl-3 col-md-6 d-flex align-items-stretch" data-aos="zoom-in" data-aos-delay="100">
                        <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#{{ strtolower($lyn->kode) }}">
                            <div class="icon-box">
                                <div class="text-center">
                                    <div class="icon"><img src="{{ $lyn->icon_layanan }}" alt=""></div>
                                    <h4><a>{{ $lyn->nama_surat }}</a></h4>
                                </div>
                            </div>
                        </button>
                    </div>
                    @endforeach
                </div>

            <!--    <div class="col-xl-3 col-md-6 d-flex align-items-stretch mt-4 mt-md-0" data-aos="zoom-in" data-aos-delay="200">-->
            <!--        <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#pkb">-->
            <!--            <div class="icon-box">-->
            <!--                <div class="text-center">-->
            <!--                    <div class="icon"><img src="assets/img/pkb.png" alt=""></i></div>-->
            <!--                    <h4><a>Pendaftaran Perjanjian Kerja Bersama</a></h4>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </button>-->
            <!--    </div>-->

            <!--    <div class="col-xl-3 col-md-6 d-flex align-items-stretch mt-4 mt-xl-0" data-aos="zoom-in" data-aos-delay="300">-->
            <!--        <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#pkwt">-->
            <!--            <div class="icon-box">-->
            <!--                <div class="text-center">-->
            <!--                    <div class="icon"><img src="assets/img/pkwt.png" alt=""></div>-->
            <!--                    <h4><a>Pendaftaran Perjanjian Kerja Waktu Tertentu</a></h4>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </button>-->
            <!--    </div>-->

            <!--    <div class="col-xl-3 col-md-6 d-flex align-items-stretch mt-4 mt-xl-0" data-aos="zoom-in" data-aos-delay="400">-->
            <!--        <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#spsb">-->
            <!--            <div class="icon-box">-->
            <!--                <div class="text-center">-->
            <!--                    <div class="icon"><img src="assets/img/spsb.png" alt=""></div>-->
            <!--                    <h4><a>Pencatatan Serikat Buruh/Serikat Pekerja</a></h4>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </button>-->
            <!--    </div>-->
            <!--</div>-->

            <!--<div class="row justify-content-center">-->
            <!--        <div class="col-xl-3 col-md-6 d-flex align-items-stretch" data-aos="zoom-in" data-aos-delay="100">-->
            <!--            <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#lks">-->
            <!--                <div class="icon-box">-->
            <!--                    <div class="text-center">-->
            <!--                        <div class="icon"><img src="assets/img/lks.png" alt=""></div>-->
            <!--                        <h4><a>Pendaftaran Lembaga Kerja Sama Bipartit</a></h4>-->
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </button>-->
            <!--        </div>-->

            <!--        <div class="col-xl-3 col-md-6 d-flex align-items-stretch mt-4 mt-md-0" data-aos="zoom-in" data-aos-delay="200">-->
            <!--            <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#hi">-->
            <!--                <div class="icon-box">-->
            <!--                    <div class="text-center">-->
            <!--                        <div class="icon"><img src="assets/img/hi.png" alt=""></div>-->
            <!--                        <h4><a>Pencatatan Penyelesaian Perselisihan Hubungan Industrial</a></h4>-->
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </button>-->
            <!--        </div>-->

            <!--        <div class="col-xl-3 col-md-6 d-flex align-items-stretch mt-4 mt-xl-0" data-aos="zoom-in" data-aos-delay="300">-->
            <!--            <button class="btn-no-border" data-bs-toggle="modal" data-bs-target="#phk">-->
            <!--                <div class="icon-box">-->
            <!--                    <div class="text-center">-->
            <!--                        <div class="icon"><img src="assets/img/phk.png" alt=""></div>-->
            <!--                        <h4><a>Pelaporan Pemutusan Hubungan Kerja</a></h4>-->
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </button>-->
            <!--        </div>-->
            <!--</div>-->
        </div>
    </section>
{{-- Akhir Section Layanan Kami --}}
<section id="kegiatan">
    <div class="section-title">
                <h2>Kegiatan</h2>
                <p></p>
            </div>
    <div class="slideshow-container">
      <!-- Full-width images with number and caption text -->
      @foreach($kegiatan as $index => $keg)
      <div class="mySlides">
        <div class="numbertext">
            <p>{{$index+1}}/{{ sizeof($kegiatan) }}</p>
            <h4>{{ $keg->judul }}</h4>
            <h5>{{ $keg->tanggal }}</h5>
        </div>
        <img src="{{ $keg->file }}" style="width:100%">
        <div class="text">
            <p>{{ $keg->caption }}</p>
        </div>
      </div>
      @endforeach
    
      <!-- Next and previous buttons -->
      <a class="prev" onclick="plusSlides(-1)">&#10094;</a>
      <a class="next" onclick="plusSlides(1)">&#10095;</a>
    </div>
    <br>
    
    <!-- The dots/circles -->
    <div style="text-align:center">
        @foreach($kegiatan as $index => $keg)
            <span class="dot" onclick="currentSlide({{ $index }})"></span>
        @endforeach
    </div>
</section>

<footer id="footer" data-aos="fade-up">
    <div class="footer-top">
      <div class="container">
        <div class="row">

          <div class="col-lg-4 col-md-6 footer-contact">
            <h3>SILAKHI</h3>
            <p>
              Jalan Soekarno Hatta <br>
              Trikora<br>
              Banjarbaru, Kalimantan Selatan <br><br>
              <strong>Phone:</strong> 0511-6749523<br>
              <strong>Email:</strong> admin@diskopukmnaker.banjarbarukota.go.id, hubunganindustrialbjb@gmail.com<br>
            </p>
          </div>

          <div class="col-lg-2 col-md-6 footer-links">
            <h4>Links</h4>
            <ul>
              <li><i class="bx bx-chevron-right"></i> <a href="#cta">Beranda</a></li>
              <li><i class="bx bx-chevron-right"></i> <a href="#about">Tentang Kami</a></li>
              <li><i class="bx bx-chevron-right"></i> <a href="#services">Layanan Kami</a></li>
              <li><i class="bx bx-chevron-right"></i> <a href="#kegiatan">Kegiatan Kami</a></li>
            </ul>
          </div>

          <div class="col-lg-3 col-md-6 footer-links">
            <h4>Layanan</h4>
            <ul>
              <li><i class="bx bx-chevron-right"></i> <a>Pengesahan PP</a></li>
              <li><i class="bx bx-chevron-right"></i> <a>Pendaftaran PKB</a></li>
              <li><i class="bx bx-chevron-right"></i> <a>Pendaftaran PKWT</a></li>
              <li><i class="bx bx-chevron-right"></i> <a>Pencatatan SP/SB</a></li>
              <li><i class="bx bx-chevron-right"></i> <a>Pendaftaran LKS Bipartit</a></li>
              <li><i class="bx bx-chevron-right"></i> <a>Pencatatan Perselisihan HI</a></li>
              <li><i class="bx bx-chevron-right"></i> <a>Pelaporan PHK</a></li>
            </ul>
          </div>

          <div class="col-lg-3 col-md-6 footer-links">
            <h4>Sosial Media Kami</h4>
            <p>Beberapa Sosial Media Kami</p>
            <div class="social-links mt-3">
              <a href="https://diskopukmnaker.banjarbarukota.go.id/" target="_blank" class="twitter"><i class='bx bxs-color'></i></a>
              <a href="https://www.instagram.com/diskopumnaker.banjarbaru/" target="_blank" class="instagram"><i class="bx bxl-instagram"></i></a>
            </div>
          </div>

        </div>
      </div>
    </div>

    <div class="container footer-bottom clearfix">
      <div class="copyright">
        &copy; Copyright <strong>MFA/MN</strong>
      </div>
      <div class="credits">
        Pemerintah Kota Banjarbaru
      </div>
    </div>
</footer>
<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

</body>
<script src="assets/vendor/aos/aos.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
<script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
<script src="assets/vendor/waypoints/noframework.waypoints.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>


<script src="assets/js/main.js"></script>
<script>
let slideIndex = 1;
showSlides(slideIndex);

function plusSlides(n) {
  showSlides(slideIndex += n);
}

function currentSlide(n) {
  showSlides(slideIndex = n);
}

function showSlides(n) {
  let i;
  let slides = document.getElementsByClassName("mySlides");
  let dots = document.getElementsByClassName("dot");
  if (n > slides.length) {slideIndex = 1}    
  if (n < 1) {slideIndex = slides.length}
  for (i = 0; i < slides.length; i++) {
    slides[i].style.display = "none";  
  }
  for (i = 0; i < dots.length; i++) {
    dots[i].className = dots[i].className.replace(" active", "");
  }
  slides[slideIndex-1].style.display = "block";  
  dots[slideIndex-1].className += " active";
}
</script>

</html>