<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/','WelcomeController@getIndex'); 

Route::get('/login', function () {
    return redirect('admin');
});

Route::get('/banjarbaru','KotaController@kecamatan');

Route::get('/json-kelurahan','KotaController@kelurahan');

Route::get('/indonesia','CountryController@provinces');

Route::get('/json-regencies','CountryController@regencies');

Route::get('/json-districts', 'CountryController@districts');

Route::get('/json-village', 'CountryController@villages');

Route::get('/json-village-like', 'CountryController@villageslike');

Route::post('/store-surat', 'SuratMasukController@store');

Route::get('/informasi','InformasiController@getIndex');
Route::get('/artikel/{slug}','InformasiController@getArtikel');

Route::get('/simpul-bansos','SimpulBansosController@getIndex'); 

Route::get('/sipena','SipenaController@getSplash'); 

Route::get('/banjir','LaporanBanjirController@getIndex'); 

Route::get('/relogin','ReLoginController@getLogout'); 

Route::get('/umkm','UmkmController@getIndex'); 

Route::get('/blog','BlogController@getIndex');
Route::get('/blog/kategori/{kategori_id}','BlogController@getIndexByKategori');
Route::get('/blog/priv/{priv}','BlogController@getIndexByPriv');
Route::get('/blog/post/{id}','BlogController@getPost');

Route::get('/osm','OsmController@getIndex');

Route::get('/intel','IntelController@getIndex');
Route::get('/intel/peta/{id}','IntelController@getPeta');
Route::get('/intel/gallery','IntelController@getGallery');
Route::get('/intel/photo_detail/{id}','IntelController@getPhotoDetail');
Route::post('intel/gallery', 'IntelController@postCariKegiatan');

Route::get('/intel/add_lapdu','IntelController@getAddLapdu');
Route::get('/intel/struktur','IntelController@getStruktur');

Route::get('/e-respon','EresponController@getIndex');
Route::get('/e-respon/profil/{id}','EresponController@getProfil');
Route::get('/e-respon/anggota','EresponController@getAnggota');
Route::get('/e-respon/fraksi','EresponController@getFraksi');
Route::get('e-respon/partai', 'EresponController@getPartai');

Route::get('scanner/{mode}', 'ScannerController@getIndex');

Route::get('/preview/{url}', 'PreviewController@getIndex');
    
   // return view('simpul-bansos.examples.dashboard');
