<?php namespace crocodicstudio\crudbooster\controllers;

use CRUDBooster;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use DateTime;
use DateInterval;
//use Debugbar;

class AdminController extends CBController
{
    function getIndex()
    {
        $data = [];
        $data['page_title'] = '<strong>Beranda</strong>';

		$privid = CRUDBooster::myPrivilegeId();
		if(CRUDBooster::myPrivilegeId()==2){
            $data['profile'] = DB::table('cms_users')
                            ->join('warga_bjb','warga_bjb.nik','cms_users.nik')
                            ->leftJoin('villages','villages.id','warga_bjb.nama_kel')
                            ->leftJoin('districts','districts.id','warga_bjb.nama_kec')
                            ->where('cms_users.id',CRUDBooster::myId())
                            ->select(DB::raw('cms_users.*,warga_bjb.id as id_warga,warga_bjb.alamat,warga_bjb.rt,warga_bjb.rw,
                                             villages.name as kelurahan, districts.name as kecamatan'))
                            ->first();
            
           
            
            // $data['pemilik'] = DB::table('umkm_pemilik')
            //                 ->where('warga_bjb_id',$data['profile']->id_warga)
            //                 ->first();
            
            // $data['usaha'] = DB::table('umkm_usaha')
            //                 ->where('warga_bjb_id',$data['profile']->id_warga)
            //                 ->get();

            $data['perusahaan'] = DB::table('perusahaan')
                            ->join('status_data','status_data.id','perusahaan.status_data_id')
                            ->where('perusahaan.created_by',CRUDBooster::myId())
                            ->selectRaw('perusahaan.*, status_data.status')
                            ->get();
                            
                            
            // $data['pelatihan'] = DB::table('surat_reg_pelatihan')
            //                 ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
            //                 ->where('warga_bjb_id',$data['profile']->id_warga)
            //                 ->where('status_id',5)
            //                 ->get();
                            
            // $data['bantuan'] = DB::table('surat_permohonan_bantuan')
            //                 ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
            //                 ->where('warga_bjb_id',$data['profile']->id_warga)
            //                 ->where('status_id',5)
            //                 ->get();
            
            return view('perusahaan.home',$data);
        }else {
            if(CRUDBooster::myPrivilegeId()!=1){
                return redirect(CRUDBooster::adminPath('surat_idv'));
            }
		}
    }

    public function getLockscreen()
    {

        if (! CRUDBooster::myId()) {
            Session::flush();

            return redirect()->route('getLogin')->with('message', trans('crudbooster.alert_session_expired'));
        }

        Session::put('admin_lock', 1);

        return view('crudbooster::lockscreen');
    }

    public function postUnlockScreen()
    {
        $id = CRUDBooster::myId();
        $password = Request::input('password');
        $users = DB::table(config('crudbooster.USER_TABLE'))->where('id', $id)->first();

        if (\Hash::check($password, $users->password)) {
            Session::put('admin_lock', 0);

            return redirect(CRUDBooster::adminPath());
        } else {
            echo "<script>alert('".trans('crudbooster.alert_password_wrong')."');history.go(-1);</script>";
        }
    }

    public function getLogin()
    {

        if (CRUDBooster::myId()) {
            return redirect(CRUDBooster::adminPath());
        }
        
        // $data['location'] = json_decode(file_get_contents('https://geolocation-db.com/json/'.$_SERVER['REMOTE_ADDR']));
        $data = [];

        return view('crudbooster::login',$data);
    }
    
    public function getLoginApp($appid,$token,$mauke)
    {
        $data = [];
        $data['appid'] = $appid;
        $data['token'] = $token;
        $data['mauke'] = $mauke;
        
        if (CRUDBooster::myId()) {
            if(strlen($mauke)>0){
			   $mauke = str_replace("-","/",$mauke);
			   return redirect(CRUDBooster::adminPath($mauke)); 
            }else{
               return redirect(CRUDBooster::adminPath());
            }
            
        }

        return view('crudbooster::loginapp',$data);
    }
    
    public function getAutologin($mauke)
	{
	    if (CRUDBooster::myId()) {
            if(strlen($mauke)>0){
			   $mauke = str_replace(";","/",$mauke);
			   return redirect(CRUDBooster::adminPath($mauke)); 
			}else{
			   return redirect(CRUDBooster::adminPath()); 
			}
        }else{
    		$email = "tamu";
            $password = "123456";
            $users = DB::table(config('crudbooster.USER_TABLE'))->where("nik", $email)->first();
            
            //dd(\Hash::make($password) . " = " . $users->password);
    
            if (\Hash::check($password, $users->password)) {
                $priv = DB::table("cms_privileges")->where("id", $users->id_cms_privileges)->first();
    
                $roles = DB::table('cms_privileges_roles')->where('id_cms_privileges', $users->id_cms_privileges)->join('cms_moduls', 'cms_moduls.id', '=', 'id_cms_moduls')->select('cms_moduls.name', 'cms_moduls.path', 'is_visible', 'is_create', 'is_read', 'is_edit', 'is_delete')->get();
    
                $photo = ($users->photo) ? asset($users->photo) : asset('vendor/crudbooster/avatar.jpg');
                Session::put('admin_id', $users->id);
                Session::put('admin_is_superadmin', $priv->is_superadmin);
                Session::put('admin_name', $users->name);
                Session::put('admin_photo', $photo);
                Session::put('admin_privileges_roles', $roles);
                Session::put("admin_privileges", $users->id_cms_privileges);
                Session::put('admin_privileges_name', $priv->name);
                Session::put('admin_lock', 0);
                Session::put('theme_color', $priv->theme_color);
                Session::put("appname", CRUDBooster::getSetting('appname'));
                
        
                CRUDBooster::insertLog(trans("crudbooster.log_login", ['email' => $users->nik, 'ip' => Request::server('REMOTE_ADDR')]));
    
                $cb_hook_session = new \App\Http\Controllers\CBHook;
                $cb_hook_session->afterLogin();
    			
    			if(strlen($mauke)>0){
    			    $mauke = str_replace(";","/",$mauke);
    			   return redirect(CRUDBooster::adminPath($mauke)); 
    			}else{
    			   return redirect(CRUDBooster::adminPath()); 
    			}
               // return redirect(CRUDBooster::adminPath())->with(['dari'=>$dari,'mauke'=>$mauke]);
            } else {
                return redirect()->route('getLogin')->with('message', trans('crudbooster.alert_password_wrong'));
            }
        }
	}
	
	public function getRegister()
    {

        // if (CRUDBooster::myId()) {
        //     return redirect(CRUDBooster::adminPath());
        // }

        // return view('crudbooster::mendaftaremail');
        
        $data = [];
        $data['kunci'] = $kunci;
        $data['body'] = '<p class="login-box-msg" id="title">Registrasi Pengguna</p>
        <form autocomplete="off" action="{{ CRUDBooster::adminPath("registerv2") }}" method="post" id="regform">
            <input type="hidden" name="_token" value="'. csrf_token() .'"/>
            <input type="hidden" name="uuid" id="uuid"/>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="text" id="niplog" class="form-control" name="nik" required pattern="[0-9]{16}" placeholder="NIK Anda"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="text" id="nama_lgkp" class="form-control" name="nama_lgkp" required placeholder="Nama Lengkap Anda"/>
                <span class="glyphicon glyphicon-book form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="tel" id="no_telp" class="form-control" name="no_telp" required pattern="[0-9]{4}[0-9]{4}[0-9]{*}" minlength="10" maxlength="12" placeholder="Nomor Hp Anda"/>
                <span class="glyphicon glyphicon-phone form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="password" id="password" class="form-control" name="password" required minlength="6" placeholder="Password Baru"/>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="password" id="repassword" class="form-control" name="repassword" required minlength="6" placeholder="Ketik password sekali lagi"/>
            </div>
            <div style="margin-bottom:10px" class="row">
                 <div class="col-xs-12">
                    <button class="btn btn-primary btn-block btn-flat"><i class="fa fa-lock"></i>Lanjut</button>
                </div>
            </div>
        </form>';
        
        if (CRUDBooster::myId()) {
            return redirect(CRUDBooster::adminPath());
        }
        
        return view('crudbooster::mendaftarv2',$data);
    }
    
    // public function getRegisterByEmail()
    // {

    //     if (CRUDBooster::myId()) {
    //         return redirect(CRUDBooster::adminPath());
    //     }

    //     return view('crudbooster::mendaftaremail');
    // }
    
    public function postRegisterByEmail()
    {
        if (!filter_var(Request::input("email"), FILTER_VALIDATE_EMAIL)) {
          $result['bahandap'] = "Invalid email format";
        }else{
            $attemp=DB::table('bahandap')->where('email',Request::input("email"))->get();
            if(sizeof($attemp)>=3){
                return redirect()->route('getLogin')->with('message', "Email ini '" . Request::input('email')  . "' tidak diperkenankan melakukan registrasi lagi ! Silahkan hubungi admin." );
                //$result['bahandap'] = 'Mohon maaf, anda tidak diperkenankan melakukan registrasi lagi.';
            }else{
                $rand = $this->generateRandomString(7);
                $exist = DB::table('bahandap')->where('kunci',$rand)->first();
                while($exist){
                    $rand = $this->generateRandomString(7);
                }
    
                $now = new DateTime();
                $now->add(new DateInterval('PT3M'));
                $result['unused'] = $now->format('Y-m-d H:i:s');
                DB::table('bahandap')->insert([
                    'kunci' => $rand,
                    'owner' => $result['cms_users_id'],
                    'redurl' => 'https://siapkk.banjarbarukota.go.id/admin/registerbot/'.$rand,
                    'hit_limit' => 9,
                    'conv_id' => $result['id'],
                    'email' => Request::input('email'),
                    'gen' => 1,
                    'updated_by' => 1,
                    'expired_at' => $now->format('Y-m-d H:i:s')
                ]);
                
                $bahandap['link'] = 'https://bjb.city/'.$rand;
                
                // //cek email exist
                // require_once 'VerifyEmail.php'; 
        
                // $mail = new VerifyEmail();
                
                // // Set the timeout value on stream
                // $mail->setStreamTimeoutWait(20);
                
                // // Set debug output mode
                // // $mail->Debug = TRUE; 
                // // $mail->Debugoutput= 'html'; 
                
                // // Set email address for SMTP request
                // $mail->setEmailFrom('admin@siapkk.banjarbarukota.go.id');
                
                // // Email to check
                // $email = Request::input('email'); 
                
                // // Check if email is valid and exist
                // if($mail->check($email)){ 
                    CRUDBooster::sendEmail(['to' => Request::input('email'), 'data' => $bahandap, 'template' => 'mendaftar']);
                    
                    return redirect()->route('getLogin')->with('message', "Kami telah mengirimkan sebuah tautan ke email anda, silahkan cek email anda."); 
                // }else{
                //     return redirect()->route('getLogin')->with('message', "Email ini '" . Request::input('email')  . "' TIDAK ADA !" ); 
                // }
                
            }
        }
        
        

        
        //var_dump($result);
    }
    
    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    public function generatePin($length = 6) {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    public function getRegisterBot($kunci)
    {

        $bahandap = DB::table('bahandap')->where('kunci',$kunci)->first();
        
        $data['kunci'] = $bahandap->kunci;

        return view('crudbooster::mendaftar',$data);
    }
    
    public function getRegisterUniq()
    {
        $data = [];
        $data['body'] = '<p class="login-box-msg" id="title">Registrasi Pengguna</p>
        <form autocomplete="off" action="https://siapkk.banjarbarukota.go.id/admin/step1" method="post" id="regform">
            <input type="hidden" name="_token" value="'. csrf_token() .'"/>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="hidden" id="kunci" class="form-control" name="kunci"  required value="{{ $kunci }}"/>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="text" id="niplog" class="form-control" name="nik" required placeholder="Masukkan NIK Anda"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div style="margin-bottom:10px" class="row">

                 <div class="col-xs-12">
                    <button class="btn btn-primary btn-block btn-flat"><i class="fa fa-lock"></i>Lanjut</button>
                </div>
            </div>
        </form>';
        
        // $ipaddress = '';
        // if (getenv('HTTP_CLIENT_IP'))
        //     $ipaddress = getenv('HTTP_CLIENT_IP');
        // else if(getenv('HTTP_X_FORWARDED_FOR'))
        //     $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        // else if(getenv('HTTP_X_FORWARDED'))
        //     $ipaddress = getenv('HTTP_X_FORWARDED');
        // else if(getenv('HTTP_FORWARDED_FOR'))
        //     $ipaddress = getenv('HTTP_FORWARDED_FOR');
        // else if(getenv('HTTP_FORWARDED'))
        //   $ipaddress = getenv('HTTP_FORWARDED');
        // else if(getenv('REMOTE_ADDR'))
        //     $ipaddress = getenv('REMOTE_ADDR');
        // else
        //     $ipaddress = 'UNKNOWN';
            
        // $attempregister = DB::table('attemp')->where('uid',$ipaddress)->count();
        if (CRUDBooster::myId()) {
            return redirect(CRUDBooster::adminPath());
        }
        
        // if($attempregister<4){
        //     DB::table('attemp')->insert(['uid'=>$ipaddress]);
            return view('crudbooster::mendaftaruid',$data);
        // }
        
        
    }
    
    protected function postStep1()
    {
        $data = [];
        $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
        $time = time();
        $agent = $_SERVER['HTTP_USER_AGENT'];
        
        $token = md5($sk . $time . $agent);
        
		$data1 = [
			'nik' => Request::input("nik"),
			'token' => '1234567890',
			'mode' => 'cari_nama'
		];

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30000,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => json_encode($data1),
			CURLOPT_HTTPHEADER => array(
				"accept: application/json",
				"content-type: application/json",
				"origin: https://siapkk.banjarbarukota.go.id",
				"X-Authorization-Token:".$token,
				"X-Authorization-Time:". $time,
				"User-Agent:".$agent
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		if ($err) {
			$hasil = $err;
		} else {
			$hasil= json_decode($response);	
			
			$data['body'] = '<p class="login-box-msg" id="title">Yang Mana Anda ?</p>
                <form autocomplete="off" action="https://siapkk.banjarbarukota.go.id/admin/step2" method="post" id="regform">
                <input type="hidden" name="_token" value="'. csrf_token() .'"/>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="kunci" class="form-control" name="kunci"  required value="{{ $kunci }}"/>
                </div>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="nik" class="form-control" name="nik"  required value="'.Request::input("nik").'"/>
                </div>
                
                <div style="margin-bottom:10px" class="row">';
                
                foreach($hasil->nama as $nama){
                    $data['body'] .= '<div class="col-xs-12"><button class="btn btn-primary btn-block btn-flat" style="margin:3px" name="nama" type="submit" value="'.$nama->nama.'">' . $nama->nama .  '</button></div>';
                }
                    
            $data['body'] .= '</div></div></form>';
            
            //return redirect()->back()->with('step1', $data['body']);
		
            return view('crudbooster::mendaftarsave',$data);
		}
		curl_close($curl);
		
	
    }
    
    protected function postStep2()
    {
        $data = [];
        $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
        $time = time();
        $agent = $_SERVER['HTTP_USER_AGENT'];
        
        $token = md5($sk . $time . $agent);
        
		$data1 = [
			'nik' => Request::input("nik"),
			'nama_lgkp' => Request::input("nama"),
			'token' => '1234567890',
			'mode' => 'cari_induk'
		];

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30000,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => json_encode($data1),
			CURLOPT_HTTPHEADER => array(
				"accept: application/json",
				"content-type: application/json",
				"origin: https://siapkk.banjarbarukota.go.id",
				"X-Authorization-Token:".$token,
				"X-Authorization-Time:". $time,
				"User-Agent:".$agent
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		if ($err) {
			$hasil = $err;
		} else {
			$hasil= json_decode($response);	
			
			$data['body'] = '<p class="login-box-msg" id="title">Yang Mana Ibu Anda ?</p>
                <form autocomplete="off" action="https://siapkk.banjarbarukota.go.id/admin/step-last" method="post" id="regform">
                <input type="hidden" name="_token" value="'. csrf_token() .'"/>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="kunci" class="form-control" name="kunci"  required value="{{ $kunci }}"/>
                </div>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="nik" class="form-control" name="nik"  required value="'.Request::input("nik").'"/>
                </div>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="nama" class="form-control" name="nama"  required value="'.Request::input("nama").'"/>
                </div>
                <div style="margin-bottom:10px" class="row">';
                
                foreach($hasil->nama as $nama){
                    $data['body'] .= '<div class="col-xs-12"><button class="btn btn-primary btn-block btn-flat" style="margin:3px" name="induk" type="submit" value="'.$nama->nama.'">' . $nama->nama .  '</button></div>';
                }
                
                
            $data['body'] .= '</div></div></form>';
    		
            return view('crudbooster::mendaftarsave',$data);
		}
		curl_close($curl);
		
		//$data['body'] = $response;
		
		
    }
    
    protected function postStepLast()
    {
        $data = [];
        $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
        $time = time();
        $agent = $_SERVER['HTTP_USER_AGENT'];
        
        $token = md5($sk . $time . $agent);
        
		$data1 = [
			'nik' => Request::input("nik"),
			'nama_lgkp' => Request::input("nama"),
			'nama_lgkp_ibu' => Request::input("induk"),
			'token' => '1234567890',
			'mode' => 'cari_induk'
		];

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30000,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => json_encode($data1),
			CURLOPT_HTTPHEADER => array(
				"accept: application/json",
				"content-type: application/json",
				"origin: https://siapkk.banjarbarukota.go.id",
				"X-Authorization-Token:".$token,
				"X-Authorization-Time:". $time,
				"User-Agent:".$agent
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		if ($err) {
			$hasil = $err;
		} else {
			$hasil= json_decode($response);	
			
			$data['body'] = '
			    <p class="login-box-msg" id="title">Ketikkan Password Yang Anda Inginkan</p>
                <form autocomplete="off" action="https://siapkk.banjarbarukota.go.id/admin/step2" method="post" id="regform">
                <input type="hidden" name="_token" value="'. csrf_token() .'"/>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="kunci" class="form-control" name="kunci"  required value="{{ $kunci }}"/>
                </div>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="nik" class="form-control" name="nik"  required value="'.Request::input("nik").'"/>
                </div>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="nama" class="form-control" name="nama"  required value="'.Request::input("nama").'"/>
                </div>
                <div class="form-group has-feedback">
                    <input autocomplete="off" type="hidden" id="induk" class="form-control" name="induk"  required value="'.Request::input("induk").'"/>
                </div>
                <div style="margin-bottom:10px" class="row">';
                
                
                
            $data['body'] .= '</div></div></form>';
    		
            return view('crudbooster::mendaftarsave',$data);
		}
		curl_close($curl);
		
		//$data['body'] = $response;
		
		
    }
	
	protected function postRegister()
    {
		$warga = DB::table('warga_bjb')
                   ->where('nik', Request::input("nik"))
                   ->first();
                   
       // var_dump($warga);
				   
		if($warga){
			//if(Request::input("district_id")!="undefined" && Request::input("village_id")!="undefined"){
				DB::table('cms_users')->insert([
					'name' => $warga->nama_lgkp,
					'nik' => $warga->nik,
					'district_id' => $warga->nama_kec,
					'village_id' => $warga->nama_kel,
					'rt' => $warga->rt,
					'rw' => $warga->rw,
					'password' => \Hash::make(Request::input("password")),
					'id_cms_privileges' => '2',
					'created_at' => Carbon::now(),
					'status' => 'Active',
					'token' => CRUDBooster::acak(Request::input("password"))
				]);
				
				return redirect()->route('getLogin')->with(['message' => "Pendaftaran berhasil, Silahkan Login", 'message_type' => 'info']);
			//}
		}else{
			return redirect()->route('getLogin')->with(['message' => "Pendaftaran Gagal, Silahkan Ulangi Proses Mendaftar.", 'message_type' => 'danger']);
		}
    }

    public function getRegisterWa()
    {
        $data = [];
        
        if (CRUDBooster::myId()) {
            return redirect(CRUDBooster::adminPath());
        }

        return view('crudbooster::mendaftarwa',$data);

        
        
    }
	
	public function getRegisterV2()
    {
        $data = [];
        $data['kunci'] = 0;
        
        if (CRUDBooster::myId()) {
            return redirect(CRUDBooster::adminPath());
        }
        
        // if($attempregister<4){
        //     DB::table('attemp')->insert(['uid'=>$ipaddress]);
            return view('crudbooster::mendaftarv2',$data);
        // }
        
        
    }
    
    public function postRegisterV2()
    {
        $data = [];
        $data['nik'] = Request::input("nik");
        $data['no_telp'] = Request::input("no_telp");
        $data['nama_lgkp'] = Request::input("nama_lgkp");
        $data['password'] = Request::input("password");
        $data['kunci'] = Request::input("kunci");
        
        $warga = DB::table('warga_bjb')->where('nik',Request::input("nik"))->select('nama_lgkp')->first();
        
        if($warga){
            similar_text($warga->nama_lgkp,strtoupper(Request::input("nama_lgkp")),$similar);
            if( $similar >= 90 ){
                $data['nama_lgkp'] = $warga->nama_lgkp;
                $attemp = DB::table('registerv2')->where('nik',Request::input('nik'))->orWhere('no_telp',Request::input('no_telp'))->get();
                
                if(sizeof($attemp)>=3){
                    return redirect()->route('getRegisterV2')->with(['message' => "Terlalu banyak percobaan, Silahkan hubungi admin.", 'message_type' => 'danger']);
                }else{
                     $exist = DB::table('cms_users')->where('nik',Request::input("nik"))->first();
                     if(!$exist){
                        DB::table('registerv2')->where('nik',Request::input("nik"))->where('no_telp',Request::input("no_telp"))->where('otp_status','>',-1)->update(['otp_status'=>-1]);
                        DB::table('registerv2')->insert(['no_telp'=>Request::input("no_telp"),'nik'=>Request::input("nik"),'device_id'=>Request::input("uuid"),'created_at'=>now()]);
                        return view('crudbooster::mendaftarv2pin',$data);
                    }else{
                        return redirect()->route('getRegisterV2')->with(['message' => "NIK Sudah terdaftar !", 'message_type' => 'danger']); 
                    }
                }
            }else{
                return redirect()->route('getRegisterV2')->with(['message' => "Data tidak sesuai !", 'message_type' => 'danger']);
            }
        }else{
            $attemp = DB::table('registerv2')->where('nik',Request::input('nik'))->orWhere('no_telp',Request::input('no_telp'))->get();
            
            if(sizeof($attemp)>0){
                return redirect()->route('getRegisterV2')->with(['message' => "Data sudah pernah digunakan !, Silahkan hubungi admin.", 'message_type' => 'danger']);
            }else{
                DB::table('warga_bjb')->insert(['nik'=>Request::input("nik"),'nama_lgkp'=>Request::input("nama_lgkp")]);
                $exist = DB::table('cms_users')->where('nik',Request::input("nik"))->first();
                if(!$exist){
                    DB::table('registerv2')->where('nik',Request::input("nik"))->where('no_telp',Request::input("no_telp"))->where('otp_status','>',-1)->update(['otp_status'=>-1]);
                    DB::table('registerv2')->insert(['no_telp'=>Request::input("no_telp"),'nik'=>Request::input("nik"),'device_id'=>Request::input("uuid"),'created_at'=>now()]);
                    return view('crudbooster::mendaftarv2pin',$data);
                }else{
                    return redirect()->route('getRegisterV2')->with(['message' => "NIK Sudah terdaftar !", 'message_type' => 'danger']); 
                }
            }
        }
    }
    
    public function getRegisterV2Pin()
    {
        return view('crudbooster::mendaftarv2pin');
    }
    
    public function postRegisterV2Pin()
    {
        $data = [];
        $data['nik'] = Request::input("nik");
        $data['no_telp'] = Request::input("no_telp");
        $data['nama_lgkp'] = Request::input("nama_lgkp");
        $data['password'] = Request::input("password");
        $data['kunci'] = Request::input("kunci");
        $benar = DB::table('registerv2')->where('nik',Request::input("nik"))->where('no_telp',Request::input("no_telp"))->where('otp_status','>',-1)->where('otp',Request::input("otp"))->first();
        if($benar){
            $newId = DB::table('cms_users')->insertGetId(['name'=>Request::input("nama_lgkp"),'nik'=>Request::input("nik"),'no_telp'=>Request::input("no_telp"),'password' => \Hash::make(Request::input("password")),'verified'=>30,'id_cms_privileges'=>2]);
            DB::table('multi_privs')->insert(['cms_users_id'=>$newId,'cms_privileges_id'=>31]);
            DB::table('registerv2')->where('id',$benar->id)->update(['otp_status'=>5]);
            return redirect()->route('getLogin')->with('message', "Pendaftaran Akun Berhasil,Silahkan Login"); 
        }else{
            if(Request::input("kunci") < 3){
                return view('crudbooster::mendaftarv2pin',$data);
            }else{
                return redirect()->route('getLogin')->with('message', "Sesi OTP anda telah berakhir !");
            }
        }
     
    }

    public function postLogin()
    {

        $validator = Validator::make(Request::all(), [
            //'email' => 'required|email|exists:'.config('crudbooster.USER_TABLE'),
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors()->all();

            return redirect()->back()->with(['message' => implode(', ', $message), 'message_type' => 'danger']);
        }
		$dari = Request::input("dari");	
		$mauke = Request::input("mauke");			
		
        $email = Request::input("email");
        $password = Request::input("password");
        $users = DB::table(config('crudbooster.USER_TABLE'))->where("nik", $email)->first();

        if (\Hash::check($password, $users->password)) {
            $priv = DB::table("cms_privileges")->where("id", $users->id_cms_privileges)->first();

            $roles = DB::table('cms_privileges_roles')->where('id_cms_privileges', $users->id_cms_privileges)->join('cms_moduls', 'cms_moduls.id', '=', 'id_cms_moduls')->select('cms_moduls.name', 'cms_moduls.path', 'is_visible', 'is_create', 'is_read', 'is_edit', 'is_delete')->get();

            $photo = ($users->photo) ? asset($users->photo) : asset('vendor/crudbooster/avatar.jpg');
            Session::put('admin_id', $users->id);
            Session::put('admin_is_superadmin', $priv->is_superadmin);
            Session::put('admin_name', $users->name);
            Session::put('admin_photo', $photo);
            Session::put('admin_privileges_roles', $roles);
            Session::put("admin_privileges", $users->id_cms_privileges);
            Session::put('admin_privileges_name', $priv->name);
            //Session::put("dinas_id", $priv->dinas_id);
            Session::put('admin_lock', 0);
            Session::put('theme_color', $priv->theme_color);
            Session::put("appname", CRUDBooster::getSetting('appname'));

            CRUDBooster::insertLog(trans("crudbooster.log_login", ['email' => $users->nik, 'ip' => Request::server('REMOTE_ADDR')]));

            $cb_hook_session = new \App\Http\Controllers\CBHook;
            $cb_hook_session->afterLogin();
			
			if(strlen($mauke)>0){
			    $mauke = str_replace("-","/",$mauke);
			   return redirect(CRUDBooster::adminPath($mauke)); 
			}else{
			   return redirect(CRUDBooster::adminPath()); 
			}
           // return redirect(CRUDBooster::adminPath())->with(['dari'=>$dari,'mauke'=>$mauke]);
        } else {
            return redirect()->route('getLogin')->with('message', trans('crudbooster.alert_password_wrong'));
        }
    }
    
    public function postBerubah()
    {
        $aktif = DB::table('cms_privileges')->where('id',Request::input("priv_id"))->first();
        if($aktif->aktif==1){
            $exist = DB::table('multi_privs')->where('cms_users_id',CRUDBooster::myId())->where('cms_privileges_id',Request::input("priv_id"))->first();
            if($exist || Request::input("priv_id") == 2){
                $roles = DB::table('cms_privileges_roles')->where('id_cms_privileges', Request::input("priv_id"))->join('cms_moduls', 'cms_moduls.id', '=', 'id_cms_moduls')->select('cms_moduls.name', 'cms_moduls.path', 'is_visible', 'is_create', 'is_read', 'is_edit', 'is_delete')->get();
                $priv = DB::table('cms_privileges')->where('id',Request::input("priv_id"))->first();
                $users = DB::table(config('crudbooster.USER_TABLE'))->where("id", CRUDBooster::myId())->first();
                $photo = ($users->photo) ? asset($users->photo) : asset('vendor/crudbooster/avatar.jpg');
                Session::put('admin_id', $users->id);
                Session::put('admin_is_superadmin', $priv->is_superadmin);
                Session::put('admin_name', $users->name);
                Session::put('admin_photo', $photo);
                Session::put('admin_privileges_roles', $roles);
                Session::put("admin_privileges", Request::input("priv_id"));
                Session::put('admin_privileges_name', $priv->name);
                Session::put('theme_color', $priv->theme_color);
                Session::put("dinas_id", $users->dinas_id);
                Session::put("admin_rt", $users->rt);
                Session::put("admin_village", $users->village_id);
                Session::put("admin_district", $users->district_id);
                Session::put("admin_regency", $users->regency_id);
                Session::put("admin_province", $users->province_id);
                Session::put("admin_rw", $users->rw);
                
                CRUDBooster::insertLog(trans("User berubah menjadi " . Request::input("priv_id"), ['email' => Request::input("nik"), 'ip' => Request::server('REMOTE_ADDR')]));
                
                DB::table(config('crudbooster.USER_TABLE'))->where("id", CRUDBooster::myId())->update(['selected_id_cms_priv'=>Request::input("priv_id")]);
                
                $cb_hook_session = new \App\Http\Controllers\CBHook;
                $cb_hook_session->afterLogin();
                
                return redirect()->route('getLogin');
            }else{
                DB::table('blacklist')->insert(['cms_users_id'=>CRUDBooster::myId(),'keterangan'=>'pelanggaran berubah']);
                return view('crudbooster::banned');
            }
        }else{
            return redirect()->route('getLogin');
        }
    }
    
    public function getForgot()
    {
        if (CRUDBooster::myId()) {
            return redirect(CRUDBooster::adminPath());
        }

        //return view('crudbooster::forgot');
		return view('crudbooster::forgot2');
    }

    public function postForgot()
    {
        $percobaan = DB::table('surat_lupa')->where('nik',Request::input('nik'))->count();
        if($percobaan>2){
            $message = 'Terlalu banyak percobaan !';
            
            DB::table('surat_lupa')->insert(['nik'=>Request::input('nik'),'email'=>Request::input('email'),'no_telp'=>Request::input('no_telp'),'genpass'=>$message,'user_agent'=>Request::server('REMOTE_ADDR'),'created_at'=>now()]);
            
            return redirect()->back()->with(['message' => $message, 'message_type' => 'danger']);
        }
        
        $exist = DB::table('cms_users')->where('nik',Request::input('nik'))->first();
        
        if (strlen($exist->nik)==0) {
            $message = 'Data tidak ditemukan !';
            
            DB::table('surat_lupa')->insert(['nik'=>Request::input('nik'),'email'=>Request::input('email'),'no_telp'=>Request::input('no_telp'),'genpass'=>$message,'user_agent'=>Request::server('REMOTE_ADDR'),'created_at'=>now()]);
            
            return redirect()->back()->with(['message' => $message, 'message_type' => 'danger']);
        }
        

        $nama_exp =  explode(" ", $exist->name);
        if(strtolower($nama_exp[0])!=strtolower(Request::input('nama_depan'))){
            $message = 'Nama tidak sesuai !';
            
            DB::table('surat_lupa')->insert(['nik'=>Request::input('nik'),'email'=>Request::input('email'),'no_telp'=>Request::input('no_telp'),'genpass'=>$message,'user_agent'=>Request::server('REMOTE_ADDR'),'created_at'=>now()]);
            
            return redirect()->back()->with(['message' => $message, 'message_type' => 'danger']);
        }
        // $validator = Validator::make(Request::all(), [
        //     'email' => 'required|email|exists:'.config('crudbooster.USER_TABLE'),
        // ]);

        // if ($validator->fails()) {
        //     $message = $validator->errors()->all();

        //     return redirect()->back()->with(['message' => implode(', ', $message), 'message_type' => 'danger']);
        // }

        $rand_string = str_random(5);
        $password = \Hash::make($rand_string);

        DB::table(config('crudbooster.USER_TABLE'))->where('nik', Request::input('nik'))->update(['password' => $password]);

        $appname = CRUDBooster::getSetting('appname');
        //$user = CRUDBooster::first(config('crudbooster.USER_TABLE'), ['email' => g('email')]);
        $user = DB::table(config('crudbooster.USER_TABLE'))->where('nik', Request::input('nik'))->first();
        $user->password = $rand_string;

        
       // CRUDBooster::sendEmail(['to' => Request::input('email'), 'data' => $user, 'template' => 'forgot_password_backend']);

        //CRUDBooster::insertLog(trans("crudbooster.log_forgot", ['email' => g('email'), 'ip' => Request::server('REMOTE_ADDR')]));
        
        DB::table('surat_lupa')->insert(['nik'=>Request::input('nik'),'email'=>Request::input('email'),'no_telp'=>Request::input('no_telp'),'genpass'=>$rand_string,'user_agent'=>Request::server('REMOTE_ADDR'),'created_at'=>now()]);

        return redirect()->route('getLogin')->with('message', trans("crudbooster.message_forgot_password"));
    }
    
    
    public function getLogout()
    {

        $me = CRUDBooster::me();
        CRUDBooster::insertLog(trans("crudbooster.log_logout", ['email' => $me->email]));

        Session::flush();

        return redirect()->route('getLogin')->with('message', trans("crudbooster.message_after_logout"));
    }
}
