@if($row->lat && $row->lon)
	<div class="map" id='map'></div>
	{{$value}}
@else
    {{$value}}
@endif


<div id='googlemaps-modal-{{$name}}' class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><i class='fa fa-search'></i> View Map</h4>
            </div>
            <div class="modal-body">

                <div class="map" id='map'></div>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


@push('bottom')
    <script type="text/javascript">
	    @if($row->lat && $row->lon)
			initMap{{$name}}();
		@endif
        function showModalMap{{$name}}() {
            $('#googlemaps-modal-{{$name}}').modal('show');
        }

        var is_init_map_{{$name}} = false;
        $('#googlemaps-modal-{{$name}}').on('shown.bs.modal', function () {
            if (is_init_map_{{$name}} == false) {
                initMap{{$name}}();
                is_init_map_{{$name}} = true;
            }
        });

        function initMap{{$name}}() {
            @if($row->lat && $row->lon)
			  var map, newUser, users, mapquest, firstLoad, videofirst, layers;

			  firstLoad = true;
			  videofirst = true;

			  //users = new L.FeatureGroup();
			  users = new L.MarkerClusterGroup({spiderfyOnMaxZoom: true, showCoverageOnHover: false, zoomToBoundsOnClick: true});
			  newUser = new L.LayerGroup();

			  mapquest = new L.TileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
				maxZoom: 18,
				attribution: 'Basemap tiles courtesy of <a href="http://www.mapquest.com/" target="_blank">MapQuest</a> <img src="http://developer.mapquest.com/content/osm/mq_logo.png">. Map data (c) <a href="http://www.openstreetmap.org/" target="_blank">OpenStreetMap</a> contributors, CC-BY-SA.'
			  });
			   //alert(<?php echo $row->lat ?: 0;?>);
			  layers = [mapquest, users, newUser];
			  map = new L.Map('map', {
				@if($row->lat && $row->lon)
				center: {lat: <?php echo $row->lat ?: 0;?>, lng: <?php echo $row->lon ?: 0;?> },
				zoom: 18,
				@else		 
				center: new L.LatLng(-3.440513, 114.83058),
				zoom: 14,
				@endif        
				
				layers: layers
			  });
			  
			  @if($row->lat && $row->lon)
				//  alert("<?php echo $row->icon ?: 0;?>");
				 var markerIcon = L.icon({
					iconUrl: 'http://localhost/siapkk/public/<?php echo $row->icon; ?>',

					iconSize:     [80, 80], // size of the icon
					shadowSize:   [70, 64], // size of the shadow
					iconAnchor:   [20, 90], // point of the icon which will correspond to marker's location
					shadowAnchor: [4, 62],  // the same for the shadow
					popupAnchor:  [-3, -76] // point from which the popup should open relative to the iconAnchor
				});
				 markThis(<?php echo $row->lat ?: 0;?>,<?php echo $row->lon ?: 0;?>);
			  @endif
			  
			  function markThis(lat,lon){
				  var markerLocation = new L.LatLng(lat, lon);
				  var marker = new L.Marker(markerLocation);
				  newUser.clearLayers();
				  newUser.addLayer(marker);
			  }
            @else
            $('#googlemaps-modal-{{$name}} .modal-body').html("<div align='center'>Sorry the map is not found !</div>");
            @endif
        }
    </script>
@endpush        					    
