<div class='form-group {{$header_group_class}} {{ ($errors->first($name))?"has-error":"" }}' id='form-group-{{$name}}' style="{{@$form['style']}}">
    <label class='control-label col-sm-2'>
        {{$form['label']}}
        @if($required)
            <span class='text-danger' title='{!! trans('crudbooster.this_field_is_required') !!}'>*</span>
        @endif
    </label>

    <div class="{{$col_width?:'col-sm-10'}}">

        <input type='text' title="{{$form['label']}}"
               {{$required}} {{$readonly}} {!!$placeholder!!} {{$disabled}} {{$validation['max']?"maxlength=".$validation['max']:""}} class='form-control '
               name="{{$name}}" id="{{$name}}" value='{{$value}}' qrcode="{{@$form['qrcode']}}" mainurl="{{@$form['mainurl']}}" />
        
        <div class="text-danger">{!! $errors->first($name)?"<i class='fa fa-info-circle'></i> ".$errors->first($name):"" !!}</div>
        <p class='help-block'>{{ @$form['help'] }}</p>
        @if(isset($form['qrcode']))
        <div class='qrcode'></div>
        @endif

    </div>
</div>
@if(isset($form['qrcode']))
@push("bottom")
    <script src="{{ CRUDBooster::adminPath() }}/js/qrcode.min.js"></script>
    <script>
        // $( document ).ready(function() {
        //     renderQR();
        // });
        $('[qrcode=1]').on("input", function() {
            if($(this).val().length>3){
                $( ".qrcode" ).html("https://" + $(this).attr('mainurl') + "/" + $(this).val());
                renderQR();
            }else{
                $( ".qrcode" ).empty();
            }
        });
        function renderQR(){
            $( ".qrcode" ).each(function() {
                if($(this).html().length>0){
                    new QRCode(this, {
                        text :  $(this).html(),
                        width : 80,
                        height : 80
                    });
                    //console.log($(this).find('img').attr('src'))
                    //$(this).append('<a href="'+ $(this).attr('src') +'">Download QR</a>');
                }
                
            });
            
        }
        

    </script>
@endpush
@endif