<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{trans("crudbooster.page_title_login")}} : {{Session::get('appname')}}</title>
    <meta name='generator' content='CRUDBooster'/>
    <meta name='robots' content='noindex,nofollow'/>
    <link rel="shortcut icon"
          href="{{ CRUDBooster::getSetting('favicon')?asset(CRUDBooster::getSetting('favicon')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}">

    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome Icons -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <!-- Theme style -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/dist/css/AdminLTE.min.css')}}" rel="stylesheet" type="text/css"/>

    <!-- support rtl-->
    @if (in_array(App::getLocale(), ['ar', 'fa']))
        <link rel="stylesheet" href="//cdn.rawgit.com/morteza/bootstrap-rtl/v3.3.4/dist/css/bootstrap-rtl.min.css">
        <link href="{{ asset("vendor/crudbooster/assets/rtl.css")}}" rel="stylesheet" type="text/css"/>
@endif

<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <link rel='stylesheet' href='{{asset("vendor/crudbooster/assets/css/main.css")}}'/>
    <style type="text/css">
        .login-page, .register-page {
            background: {{ CRUDBooster::getSetting("login_background_color")?:'#dddddd'}} url('{{ CRUDBooster::getSetting("login_background_image")?asset(CRUDBooster::getSetting("login_background_image")):asset('vendor/crudbooster/assets/bg_blur3.jpg') }}');
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#ffffff' }}  !important;
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover;
        }

        .login-box, .register-box {
            margin: 2% auto;
        }

        .login-box-body {
            box-shadow: 0px 0px 50px rgba(0, 0, 0, 0.8);
            background: rgba(255, 255, 255, 0.9);
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#666666' }}  !important;
        }

        /*html, body {*/
        /*    overflow: hidden;*/
        /*}*/

    </style>
</head>

<body class="login-page">

<div class="login-box">
    <div class="login-logo">
        <a href="{{url('/')}}">
            <img title='{!!(Session::get('appname') == 'CRUDBooster')?"<b>CRUD</b>Booster":CRUDBooster::getSetting('appname')!!}'
                 src='{{ CRUDBooster::getSetting("logo")?asset(CRUDBooster::getSetting('logo')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}'
                 style='max-width: 100%;max-height:180px'/>
        </a>
    </div><!-- /.login-logo -->
    <div class="login-box-body">
        <h3 class="login-box-msg" id="title">Login Pengguna</h3>

        @if ( Session::get('message') != '' )
            <div class='alert alert-warning'>
                {{ Session::get('message') }}
            </div>
        @endif

        <p class='login-box-msg'>{{trans("crudbooster.login_message")}}</p>
        <form autocomplete='off' action="{{ route('postLogin') }}" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
			<input type="hidden" name="dari" id="dari-input" value=""/>
			<input type="hidden" name="mauke" id="mauke-input" value=""/>
            <div class="form-group has-feedback">
                <input autocomplete='off' type="text" class="form-control" name='email' required placeholder="NIK" id="nik-input"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback" id="show_hide_password">
                <input autocomplete='off' type="password" class="form-control" name='password' required placeholder="Password" id="password-input"/>
                <!--<div class="input-group-addon">-->
                <!--    <btn onclick="showPass()"><i class="fa fa-eye-slash" aria-hidden="true"></i></btn>-->
                <!-- </div>-->
                 <span class="glyphicon glyphicon-lock form-control-feedback"></span>
            </div>
            <input type="checkbox" onclick="myFunction()">Show Password
            <div style="margin-bottom:10px" class='row'>
                <div class='col-sm-6'>
                    <button type="submit" class="btn btn-primary btn-block btn-flat" id="submit-button"><i class='fa fa-lock'></i> {{trans("crudbooster.button_sign_in")}}</button>
                </div>
				<div class='col-sm-6'>
                    <a class="btn btn-info btn-block btn-flat" onclick="location.href = '{{ route('getRegisterWa') }}'"><i class='fa fa-list'></i> Mendaftar</a>
                </div>
            </div>

            <!--<div class='row'>-->
            <!--    <div class='col-xs-12' align="center"><p style="padding:10px 0px 10px 0px">{{trans("crudbooster.text_forgot_password")}} <a-->
            <!--                    href='{{route("getForgot")}}'>{{trans("crudbooster.click_here")}}</a></p></div>-->
            <!--</div>-->
            
            <br>
 
        </form>


        <br/>
        <!--a href="#">I forgot my password</a-->

    </div><!-- /.login-box-body -->

</div><!-- /.login-box -->


<!-- jQuery 2.1.3 -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.2 JS -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/js/bootstrap.min.js')}}" type="text/javascript"></script>

</body>
<script>
    function myFunction() {
      var x = document.getElementById("password-input");
      if (x.type === "password") {
        x.type = "text";
      } else {
        x.type = "password";
      }
    }
	$(document).ready(function() {
	    var registerstat = '{!! Session::get('message') !!}';
		
		if(registerstat=='Pendaftaran Akun Berhasil,Silahkan Login'){
		    console.log(registerstat);
		    window.Android.postMessage('backtologin;login');
		}
	    
		var pathname = window.location.pathname; // Returns path only (/path/example.html)
		var url      = window.location.href;     // Returns full URL (https://example.com/path/example.html)
		var origin   = window.location.origin; 
		if(url == 'https://siapkk.banjarbarukota.go.id/admin/login'){
			var akun =  Android.getSiapkk();
			var res = akun.split(",");
			if(res.length>0){
				$('#nik-input').val(res[0]);
				$('#password-input').val(res[1]);
				$('#dari-input').val(res[3]);
				$('#mauke-input').val(res[2]);
				
				$( "#submit-button" ).trigger( "click" );
				
			}
		}
		
		
	});
</script>
</html>