<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{trans("crudbooster.page_title_login")}} : {{Session::get('appname')}}</title>
    <meta name='generator' content='CRUDBooster'/>
    <meta name='robots' content='noindex,nofollow'/>
    <link rel="shortcut icon"
          href="{{ CRUDBooster::getSetting('favicon')?asset(CRUDBooster::getSetting('favicon')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}">

    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome Icons -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <!-- Theme style -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/dist/css/AdminLTE.min.css')}}" rel="stylesheet" type="text/css"/>

    <!-- support rtl-->
    @if (in_array(App::getLocale(), ['ar', 'fa']))
        <link rel="stylesheet" href="//cdn.rawgit.com/morteza/bootstrap-rtl/v3.3.4/dist/css/bootstrap-rtl.min.css">
        <link href="{{ asset("vendor/crudbooster/assets/rtl.css")}}" rel="stylesheet" type="text/css"/>
@endif

<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <link rel='stylesheet' href='{{asset("vendor/crudbooster/assets/css/main.css")}}'/>
    <style type="text/css">
        .login-page, .register-page {
            background: {{ CRUDBooster::getSetting("login_background_color")?:'#dddddd'}} url('{{ CRUDBooster::getSetting("login_background_image")?asset(CRUDBooster::getSetting("login_background_image")):asset('vendor/crudbooster/assets/bg_blur3.jpg') }}');
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#ffffff' }}  !important;
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover;
        }

        .login-box, .register-box {
            margin: 1% auto;
        }

        .login-box-body {
            box-shadow: 0px 0px 50px rgba(0, 0, 0, 0.8);
            background: rgba(255, 255, 255, 0.9);
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#666666' }}  !important;
        }

        html, body {
            overflow: hidden;
        }
    </style>
</head>

<body class="login-page">

<div class="login-box">
    <div class="login-logo" style="margin-bottom:-10px;">
        <a href="{{url('/')}}">
            <img title='{!!(Session::get('appname') == 'CRUDBooster')?"<b>CRUD</b>Booster":CRUDBooster::getSetting('appname')!!}'
                 src='{{ CRUDBooster::getSetting("logo")?asset(CRUDBooster::getSetting('logo')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}'
                 style='max-width: 100%;height:30px'/>
        </a>
    </div><!-- /.login-logo -->
	<br>
    <div class="login-box-body">
        

        @if ( Session::get('message') != '' )
            <div class='alert alert-warning'>
                {{ Session::get('message') }}
            </div>
        @endif

        <p class='login-box-msg' id="title">Registrasi Pengguna</p>
        <div  id="regform">
        <form autocomplete='off' action="javascript:cariLokal();" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
            <div class="form-group has-feedback">
                <input autocomplete='off' type="hidden" id="kunci" class="form-control" name='kunci'  required value="{{ $kunci }}"/>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete='off' type="text" id="niplog" class="form-control" name='nip' required placeholder="Masukkan NIK Anda"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div style="margin-bottom:10px" class='row'>

                 <div class='col-xs-12'>
                    <button class="btn btn-primary btn-block btn-flat"><i class='fa fa-lock' "></i> Lanjut</button>
                </div>
            </div>
        </form>
        </div>
        
         @if ( Session::get('message') != '' )
            <button class="btn btn-primary btn-block btn-flat" onclick="Android.backToLogin();"><i class='fa fa-arrow-left'></i> Kembali</button>
         @endif

        <br/>
        <!--a href="#">I forgot my password</a-->

    </div><!-- /.login-box-body -->

</div><!-- /.login-box -->


	
<!-- jQuery 2.1.3 -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.2 JS -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/js/bootstrap.min.js')}}" type="text/javascript"></script>
<!--- <script src="{{asset('js/jquery.validate.js')}}"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/core.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/md5.js"></script>
<script type="text/javascript">


	sessionStorage.host = "https://siapkk.banjarbarukota.go.id";
	sessionStorage.localhost = "https://satu.banjarbarukota.go.id/siapkk/public";
	sessionStorage.kunci=$("#kunci").val();
	sessionStorage.sk = "8ed90039d8a97c5b9fcc745ebc725a1f";
	sessionStorage.time = Date.now();
	sessionStorage.agent = navigator.userAgent;
	
//	alert(CryptoJS.MD5(sessionStorage.sk + sessionStorage.time + sessionStorage.agent).toString());
	//bahandap();
	
	function bahandap(){
	    var res = '';
	    $.ajax({
			type: "POST",
			url: sessionStorage.host+ "/api/bahandap",
			cache: false,
			data: "kunci="+sessionStorage.kunci,
			success: function (result) {
				if(result.api_status==0){
				    window.location.href="https://banjarbarukota.go.id/h/"+sessionStorage.kunci;
				}
			},
			error: function (request,error) {
				console.log(error);	
				//res = 0;
			}
		});	
	}
	
	function cariLokal(){
	    //alert(sessionStorage.host+ "/api/user_exist");
	    //bahandap();
		if($("#niplog").val()!==""){
		    
			sessionStorage.selNip=$("#niplog").val();
			$.ajax({
				type: "POST",
				url: sessionStorage.host+ "/api/user_exist",
				headers: {
                    'X-Authorization-Token':CryptoJS.MD5("dc7db71e766b24cc4398b12355a76deb" + Date.now() + navigator.userAgent),
                    'X-Authorization-Time': Date.now(),
                    'User-Agent': navigator.userAgent
                },
				cache: false,
				data: "nik="+sessionStorage.selNip,
				success: function (result) {
				    console.log(result);
					//if(result.api_status==0 && result.api_message!='THE TOKEN IS NOT MATCH WITH SERVER TOKEN'){
					if(result.api_status==0){
					    cariIni(sessionStorage.selNip);
					}else{
					    alert("Nik Sudah Terdaftar !");
					    window.location.href="https://siapkk.banjarbarukota.go.id/admin/registeruniq";
					}
				},
				error: function (request,error) {
					console.log(error);	
				}
			});	
		}else{
			alert('NIK TIdak Boleh Kosong !');
		}
	}
	
	function tdc(selnik){
        //	bahandap();
			$.ajax({
				type: "POST",
				url: sessionStorage.host+ "/api/logs",
				headers: {
                    'X-Authorization-Token':CryptoJS.MD5("dc7db71e766b24cc4398b12355a76deb" + Date.now() + navigator.userAgent),
                    'X-Authorization-Time': Date.now(),
                    'User-Agent': navigator.userAgent
                },
				cache: false,
				data: "nik="+selnik+"&mode=cari_nik",
				success: function (result) {
					if(result.api_status==0){
						alert(result.api_message);
						return false;
					}						
				},
				error: function (request,error) {
					console.log(error);	
				}
			});	
	}

	
	
	function cariIni(){
	    //bahandap();
		if($("#niplog").val()!==""){
			$("#title").html('Yang Mana Anda ?');
			sessionStorage.selNip=$("#niplog").val();
			$("#regform").empty();
			var recode = '';
			var cnt = 0;
				$.ajax({
					type: "POST",
					url: sessionStorage.host+ "/api/logs",
					headers: {
                        'X-Authorization-Token':CryptoJS.MD5("dc7db71e766b24cc4398b12355a76deb" + Date.now() + navigator.userAgent),
                        'X-Authorization-Time': Date.now(),
                        'User-Agent': navigator.userAgent
                    },
					cache: false,
					data: "nik="+sessionStorage.selNip+"&url="+window.location.href+"&mode=cari_nama",
					success: function (result) {
						var res = result;
						if(res.api_status==1){
    						$.each(res.nama, function(key,value){
    							var namacmd = "'" + value.nama + "'";
    							recode += '<button class="btn btn-primary btn-block btn-flat" onclick="cariInduk('+namacmd+');">'+value.nama+'</button>';
    							cnt++;
    						});
    						
    						$("#regform").append(recode);
						}else{
						    alert("Nik Tidak Ditemukan ! Periksa Kembali NIK Anda");
						    window.location.href="https://siapkk.banjarbarukota.go.id/admin/registeruniq";
						    //return false;
						}
						
					},
					error: function (request,error) {
						console.log(error);	
					}
				});	
		}else{
			alert('NIK TIdak Boleh Kosong !');
		}
	}
	
	function cariInduk(nama){
	   // bahandap();
		$("#title").html('Nama ibu anda ?');
		sessionStorage.selNama=nama.replace(/'/g, '\\\'');
		$("#regform").empty();
		var recode = '';
		var cnt = 0;
		$.ajax({
			type: "POST",
			url: sessionStorage.host+ "/api/logs",
			headers: {
                'X-Authorization-Token':CryptoJS.MD5("dc7db71e766b24cc4398b12355a76deb" + Date.now() + navigator.userAgent),
                'X-Authorization-Time': Date.now(),
                'User-Agent': navigator.userAgent
            },
			cache: false,
			data: "nik="+sessionStorage.selNip+"&nama_lgkp="+sessionStorage.selNama+"&mode=cari_induk",
			success: function (result) {
				//console.log(result);
				var res = result;
				if(res.api_status==1){
    				$.each(res.nama, function(key,value){
    					var namacmd = "'" + value.nama + "'";
    					recode += '<button class="btn btn-primary btn-block btn-flat" onclick="simpanInduk('+namacmd+');">'+value.nama+'</button>';
    					cnt++;
    				});
    				
    				$("#regform").append(recode);	
				}else{
				    return false;
				}
				
			},
			error: function (request,error) {
				console.log(error);	
			}
		});		
	}
	
	function simpanInduk(nama){
    //	bahandap();
	    sessionStorage.selInduk=nama.replace(/'/g, '\\\'');
	    var selnik = sessionStorage.selNip;
    	$.ajax({
    		type: "POST",
    		url: sessionStorage.host+ "/api/logs",
    		headers: {
                'X-Authorization-Token':CryptoJS.MD5("dc7db71e766b24cc4398b12355a76deb" + Date.now() + navigator.userAgent),
                'X-Authorization-Time': Date.now(),
                'User-Agent': navigator.userAgent
            },
    		cache: false,
    		data: "nik="+selnik+"&nama_lgkp="+sessionStorage.selNama+"&nama_lgkp_ibu="+sessionStorage.selInduk+"&mode=verif_selection",
    		success: function (result) {
    			//console.log(result);
    			if(result.api_status==1){
    			    tdc(selnik);
    			    $("#title").html('Password Yang Anda Inginkan');
        			$("#regform").empty();
        			
            	    var logcmd = "{{ route('postRegister') }}";
            		var recode = '';
    			    recode += '<form autocomplete="off" action="' + logcmd + '" method="post" id="lastform">';
            		recode += '<input type="hidden" name="_token" value="{{ csrf_token() }}"/>';
            		recode += '<div class="form-group has-feedback">';
                    recode +=      '<input autocomplete="off" type="text" id="nik" class="form-control" name="nik" required placeholder="NIK" value="' + selnik + '"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode += '</div>';
            		recode += '<div class="form-group has-feedback">';
                    recode +=      '<input autocomplete="off" type="text" id="name" class="form-control" name="name" required placeholder="Nama" value="' + sessionStorage.selNama + '"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode += '</div>';
            		
            		recode += '<div class="form-group has-feedback">';
                    recode +=      '<input autocomplete="new-password" type="password" id="password" class="form-control" name="password" required placeholder="Ketikan Password"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode += '</div>';
            		recode += '<div class="form-group has-feedback">';
                    recode +=     '<input autocomplete="new-password" type="password" id="repassword" class="form-control" name="repassword" required placeholder="Ketikan Password Sekali Lagi"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode +=  '</div>';
                    //recode += '<div class="form-group has-feedback">';
                    //recode +=     '<input type="checkbox" onclick="myFunction()">Lihat Password';
                    //recode +=  '</div>';
                    recode +=    '<div style="margin-bottom:10px" class="row" >';
                    recode +=        '<div class="col-xs-12">';
                    recode +=            '<button type="submit" class="btn btn-primary btn-block btn-flat">Selesai</button>';
                    recode +=        '</div>';
                    recode +=    '</div>';
            		recode += '</form>';
            		
            		$("#regform").replaceWith(recode);	
            		
            		asin();
            		
    			}else{
    			    return false;
    			}
    		},
    		error: function (request,error) {
    			console.log(error);	
    		}
		});		
	}
	
	
	function asin(){
		$('#lastform').submit(function(e) { 
		    
			if($('#password').val().length >=6){
				if($('#password').val() != $('#repassword').val()){
					alert('Password harus sama !');
					e.preventDefault(); // Cancel the submit
					return false; 
				}
			}else{
				alert('Minimal 6 karakter !');
				e.preventDefault(); // Cancel the submit
				return false; 
			}
		});
	}
	
	function myFunction() {
      var x = document.getElementById("password");
      if (x.type === "password") {
        x.type = "text";
      } else {
        x.type = "password";
      }
    }

</script>
</body>
</html>