<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{trans("crudbooster.page_title_login")}} : {{Session::get('appname')}}</title>
    <meta name='generator' content='CRUDBooster'/>
    <meta name='robots' content='noindex,nofollow'/>
    <link rel="shortcut icon"
          href="{{ CRUDBooster::getSetting('favicon')?asset(CRUDBooster::getSetting('favicon')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}">

    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome Icons -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <!-- Theme style -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/dist/css/AdminLTE.min.css')}}" rel="stylesheet" type="text/css"/>

    <!-- support rtl-->
    @if (in_array(App::getLocale(), ['ar', 'fa']))
        <link rel="stylesheet" href="//cdn.rawgit.com/morteza/bootstrap-rtl/v3.3.4/dist/css/bootstrap-rtl.min.css">
        <link href="{{ asset("vendor/crudbooster/assets/rtl.css")}}" rel="stylesheet" type="text/css"/>
    @endif

<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <link rel='stylesheet' href='{{asset("vendor/crudbooster/assets/css/main.css")}}'/>
    <style type="text/css">
        .login-page, .register-page {
            background: {{ CRUDBooster::getSetting("login_background_color")?:'#dddddd'}} url('{{ CRUDBooster::getSetting("login_background_image")?asset(CRUDBooster::getSetting("login_background_image")):asset('vendor/crudbooster/assets/bg_blur3.jpg') }}');
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#ffffff' }}  !important;
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover;
        }

        .login-box, .register-box {
            margin: 1% auto;
        }

        .login-box-body {
            box-shadow: 0px 0px 50px rgba(0, 0, 0, 0.8);
            background: rgba(255, 255, 255, 0.9);
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#666666' }}  !important;
        }

        html, body {
            overflow: hidden;
        }
      
    </style>
</head>

<body class="login-page">

<div class="login-box">
    <div class="login-logo" style="margin-bottom:-10px;">
        <a href="{{url('/')}}">
            <img title='{!!(Session::get('appname') == 'CRUDBooster')?"<b>CRUD</b>Booster":CRUDBooster::getSetting('appname')!!}'
                 src='{{ CRUDBooster::getSetting("logo")?asset(CRUDBooster::getSetting('logo')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}'
                 style='max-width: 100%;height:180px'/>
        </a>
    </div><!-- /.login-logo -->
	<br>
    <div class="login-box-body">
        

        @if ( Session::get('message') != '' )
            <div class='alert alert-warning'>
                {{ Session::get('message') }}
            </div>
        @endif

       <p class="login-box-msg" id="title">Registrasi Pengguna</p>
        <form autocomplete="off" action="{{ CRUDBooster::adminPath('registerv2') }}" method="post" id="regform">
            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
            <input type="hidden" name="uuid" id="uuid"/>
            <input type="hidden" name="kunci" id="kunci" value="{{ $kunci }}"/>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="text" id="niplog" class="form-control" name="nik" required pattern="[0-9]{16}" placeholder="NIK Anda"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="text" id="nama_lgkp" class="form-control" name="nama_lgkp" required placeholder="Nama Lengkap Anda"/>
                <span class="glyphicon glyphicon-book form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="tel" id="no_telp" class="form-control" name="no_telp" required pattern="[0-9]{4}[0-9]{4}[0-9]{4}" minlength="10" maxlength="12" placeholder="Nomor Hp Anda"/>
                <span class="glyphicon glyphicon-phone form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="password" id="password" class="form-control" name="password" required minlength="6" placeholder="Password Baru"/>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete="off" type="password" id="repassword" class="form-control" name="repassword" required minlength="6" placeholder="Ketik password sekali lagi"/>
            </div>
            <div style="margin-bottom:10px" class="row">
                 <div class="col-xs-12">
                    <button class="btn btn-primary btn-block btn-flat"><i class="fa fa-lock"></i>Lanjut</button>
                </div>
            </div>
        </form>
        <input type="checkbox" onclick="myFunction()">Show Password
    

        <br/>
        <!--a href="#">I forgot my password</a-->

    </div><!-- /.login-box-body -->

</div><!-- /.login-box -->


	
<!-- jQuery 2.1.3 -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.2 JS -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/js/bootstrap.min.js')}}" type="text/javascript"></script>
<script src="{{asset('customjs/device-uuid.min.js')}}" type="text/javascript"></script>
<!--- <script src="{{asset('js/jquery.validate.js')}}"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/core.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/md5.js"></script>
<script type="text/javascript">
function myFunction() {
      var x = document.getElementById("password");
      var y = document.getElementById("repassword");
      if (x.type === "password") {
        x.type = "text";
        y.type = "text";
      } else {
        x.type = "password";
        y.type = "password";
      }
    }
$( document ).ready(function() {
	var uuid = new DeviceUUID().get();
    $("#uuid").val(uuid);
    
    asin();
	

	function asin(){
		$('#regform').submit(function(e) { 
			if($('#password').val().length >=6){
				if($('#password').val() != $('#repassword').val()){
					alert('Password harus sama !');
					e.preventDefault(); // Cancel the submit
					return false; 
				}
			}else{
				alert('Minimal 6 karakter !');
				e.preventDefault(); // Cancel the submit
				return false; 
			}
		});
	}
	
	
});

</script>
</body>
</html>